/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.stateless;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.CompilerContext;
import net.intelie.pipes.Export;
import net.intelie.pipes.Fallback;
import net.intelie.pipes.Help;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scope;
import net.intelie.pipes.SortField;
import net.intelie.pipes.guava.collect.Ordering;
import net.intelie.pipes.modules.FallbackToSortField;
import net.intelie.pipes.stateless.BaseStatelessPipe;
import net.intelie.pipes.stateless.StatelessPipeEvaluable;
import net.intelie.pipes.types.SeqType;
import net.intelie.pipes.util.Iterables;

@Export(value={"@sort"})
@Help(key="pipe-sort")
public class SortPipe
extends BaseStatelessPipe {
    private static final long serialVersionUID = 1L;

    public SortPipe(ArgQueue queue) throws PipeException {
        this(queue.context(), (SortField[])queue.arraySafe(SortField.class, (Fallback)new FallbackToSortField()));
    }

    public SortPipe(CompilerContext config, SortField ... sorters) throws PipeException {
        super(config, (StatelessPipeEvaluable)new MyEvaluable(config, sorters));
    }

    public static class MyEvaluable
    extends StatelessPipeEvaluable {
        private static final long serialVersionUID = 1L;
        private final SortField[] sorters;
        private final SeqType type;

        public MyEvaluable(CompilerContext config, SortField ... sorters) throws PipeException {
            if (sorters.length == 0) {
                throw new PipeException((Object)"Must define at least one sort property.");
            }
            this.sorters = sorters;
            this.type = new SeqType(config.metadata().type());
        }

        @Override
        public String toString(boolean parens) {
            return BaseStatelessPipe.toString(parens, "@sort", Iterables.join((String)", ", (Object[])this.sorters));
        }

        public <T> List<T> sortAsExpected(Scope parent, Ordering<Object> sorter, Iterable<T> filtered) {
            return sorter.sortedCopy(filtered);
        }

        @Override
        public Iterable eval(Scope parent, Iterable iterable) {
            if (iterable == null) {
                return null;
            }
            ArrayList<Comparator> list = new ArrayList<Comparator>();
            for (SortField sorter : this.sorters) {
                list.add(sorter.makeComparator(parent));
            }
            return this.sortAsExpected(parent, Ordering.compound(list), iterable);
        }

        public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
            for (SortField sorter : this.sorters) {
                sorter.visit(parent, visitor);
            }
            return visitor;
        }

        @Override
        public SeqType type() {
            return this.type;
        }
    }
}

