/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.stateless;

import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.CompilerContext;
import net.intelie.pipes.Export;
import net.intelie.pipes.Fallback;
import net.intelie.pipes.GroupBy;
import net.intelie.pipes.Help;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scope;
import net.intelie.pipes.SortField;
import net.intelie.pipes.guava.collect.Ordering;
import net.intelie.pipes.modules.FallbackToSortField;
import net.intelie.pipes.stateless.BaseStatelessPipe;
import net.intelie.pipes.stateless.SortPipe;
import net.intelie.pipes.stateless.StatelessPipeEvaluable;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.Iterables;

@Export(value={"@top"})
@Help(key="pipe-top")
public class TopPipe
extends BaseStatelessPipe {
    private static final long serialVersionUID = 1L;

    public TopPipe(ArgQueue queue) throws PipeException {
        this(queue.context(), queue.groupBy(), ((Double)queue.constantValue((Type)Type.NUMBER).get()).intValue(), (SortField[])queue.arraySafe(SortField.class, (Fallback)new FallbackToSortField()));
    }

    public TopPipe(CompilerContext config, GroupBy group, int top, SortField ... sorters) throws PipeException {
        super(config, (StatelessPipeEvaluable)new MyEvaluable(config, group, top, sorters));
    }

    private static class MyEvaluable
    extends SortPipe.MyEvaluable {
        private static final long serialVersionUID = 1L;
        private final GroupBy group;
        private final int top;
        private final String repr1;
        private final String repr2;

        public MyEvaluable(CompilerContext config, GroupBy group, int top, SortField[] sorters) throws PipeException {
            super(config, sorters);
            if (top <= 0) {
                throw new PipeException((Object)"Top number must be greater than zero.");
            }
            this.group = group;
            this.top = top;
            this.repr1 = this.makeRepr(true, group, top, sorters);
            this.repr2 = this.makeRepr(false, group, top, sorters);
        }

        private String makeRepr(boolean parens, GroupBy group, int top, SortField[] sorters) {
            return BaseStatelessPipe.toString(parens, "@top", top + ", " + Iterables.join((String)", ", (Object[])sorters) + (group.size() > 0 ? " " + group : ""));
        }

        @Override
        public <T> List<T> sortAsExpected(Scope parent, Ordering<Object> sorter, Iterable<T> filtered) {
            GroupBy.State state = this.group.newState(key -> new PriorityQueue(this.top, sorter.reverse()));
            for (T obj : filtered) {
                if (obj == null) continue;
                PriorityQueue queue = (PriorityQueue)state.get(parent, obj);
                if (queue.size() + 1 > this.top) {
                    if (sorter.compare(queue.peek(), obj) <= 0) continue;
                    queue.poll();
                    queue.add(obj);
                    continue;
                }
                queue.add(obj);
            }
            ArrayList list = new ArrayList();
            for (PriorityQueue queue : state) {
                list.addAll(sorter.sortedCopy(queue));
            }
            return list;
        }

        @Override
        public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
            this.group.visit(parent, visitor);
            return super.visit(parent, visitor);
        }

        @Override
        public String toString(boolean parens) {
            return parens ? this.repr1 : this.repr2;
        }
    }
}

