/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.stateless;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Export;
import net.intelie.pipes.Help;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.modules.FallbackToUnderscore;
import net.intelie.pipes.stateless.BaseStatelessPipe;
import net.intelie.pipes.stateless.StatelessPipeEvaluable;
import net.intelie.pipes.types.SeqType;
import net.intelie.pipes.types.Type;

@Export(value={"@zip"})
@Help(key="pipe-zip")
public class ZipPipe
extends BaseStatelessPipe {
    private static final long serialVersionUID = 1L;

    public ZipPipe(ArgQueue queue) throws PipeException {
        super(queue.context(), (StatelessPipeEvaluable)new MyEvaluable(queue));
    }

    private static class ZipIterable
    implements Iterable<Iterable<Object>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final List<Iterable<Object>> iterables;

        public ZipIterable(List<Iterable<Object>> iterables) {
            this.iterables = iterables;
        }

        @Override
        public Iterator<Iterable<Object>> iterator() {
            final ArrayList iterators = new ArrayList();
            for (Iterable<Object> iterable : this.iterables) {
                iterators.add(iterable != null ? iterable.iterator() : Collections.emptyIterator());
            }
            return new Iterator<Iterable<Object>>(){

                @Override
                public boolean hasNext() {
                    boolean hasNext = true;
                    for (Iterator iterator : iterators) {
                        hasNext = hasNext && iterator.hasNext();
                    }
                    return hasNext;
                }

                @Override
                public Iterable<Object> next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException("no more elements");
                    }
                    ArrayList<Object> list = new ArrayList<Object>(iterators.size());
                    for (Iterator iterator : iterators) {
                        list.add(iterator.next());
                    }
                    return list;
                }
            };
        }
    }

    private static class MyEvaluable
    extends StatelessPipeEvaluable {
        private static final long serialVersionUID = 1L;
        private final Scalar<Iterable> expr;
        private final SeqType type;

        public MyEvaluable(ArgQueue queue) throws PipeException {
            this.expr = (Scalar)queue.scalar((Type)Type.SEQ).getOptional(new FallbackToUnderscore(Type.SEQ));
            SeqType seqType = (SeqType)Type.extract((Type)this.expr.type(), SeqType.class);
            this.type = new SeqType((Type)seqType);
        }

        @Override
        public Iterable eval(Scope parent, Iterable iterable) {
            if (iterable == null) {
                return null;
            }
            ArrayList<Iterable<Object>> result = new ArrayList<Iterable<Object>>();
            for (Object obj : iterable) {
                result.add((Iterable<Object>)this.expr.eval(parent, obj));
            }
            return new ZipIterable(result);
        }

        public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
            return this.expr.visit(parent, visitor);
        }

        @Override
        public SeqType type() {
            return this.type;
        }

        @Override
        public String toString(boolean parens) {
            return BaseStatelessPipe.toString(parens, "@zip", this.expr);
        }
    }
}

