/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util;

public abstract class BaseConverter {
    private static char toChar(long value) {
        if (value < 10L) {
            return (char)(value + 48L);
        }
        return (char)(value - 10L + 97L);
    }

    private static int fromChar(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'z') {
            return c + 10 - 97;
        }
        if ('A' <= c && c <= 'Z') {
            return c + 10 - 65;
        }
        return -1;
    }

    public static String toBase(long number, int base) {
        if (base < 1 || base > 36) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean negative = number < 0L;
        for (number = Math.abs(number); number > 0L; number /= (long)base) {
            sb.append(BaseConverter.toChar(number % (long)base));
        }
        if (negative) {
            sb.append('-');
        }
        return sb.reverse().toString();
    }

    public static Double fromBase(String s, int base) {
        int i;
        if (base < 1 || base > 36) {
            return null;
        }
        boolean negative = s.length() > 0 && s.charAt(0) == '-';
        double value = 0.0;
        int n = i = negative ? 1 : 0;
        while (i < s.length()) {
            value *= (double)base;
            int v = BaseConverter.fromChar(s.charAt(i));
            if (v < 0 || v >= base) {
                return null;
            }
            value += (double)v;
            ++i;
        }
        if (negative) {
            value = -value;
        }
        return value;
    }
}

