/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.intelie.pipes.time.ManualSchedulerContext;

public class ClusterHelper {
    private final ManualSchedulerContext context;
    private final Map<Object, Slot> slots;
    private volatile long lastTimestamp = -1L;
    private volatile long expected = 0L;
    private volatile long queued = 0L;

    public ClusterHelper(ManualSchedulerContext context, int initialExpectedNodes) {
        this.context = context;
        this.expected = initialExpectedNodes;
        this.slots = new HashMap<Object, Slot>();
    }

    public void startAt(long timestamp) {
        this.context.advanceTo(timestamp);
        this.context.start();
    }

    public synchronized void advanceTo(Object key, long timestamp) {
        Slot slot = this.getSlot(key);
        if (timestamp <= this.lastTimestamp) {
            return;
        }
        if (slot.queued) {
            this.flip();
        }
        slot.timestamp = timestamp;
        slot.queued = true;
        ++this.queued;
        if (this.expected >= 0L && this.queued == (long)this.slots.size() + this.expected) {
            this.flip();
        }
    }

    private Slot getSlot(Object key) {
        Slot slot = this.slots.get(key);
        if (slot == null) {
            slot = new Slot();
            this.slots.put(key, slot);
            if (this.expected > 0L) {
                --this.expected;
            }
        }
        return slot;
    }

    private void flip() {
        long minTimestamp = Long.MAX_VALUE;
        for (Slot otherSlot : this.slots.values()) {
            if (!otherSlot.queued) continue;
            minTimestamp = Math.min(minTimestamp, otherSlot.timestamp);
        }
        Iterator<Slot> it = this.slots.values().iterator();
        while (it.hasNext()) {
            Slot otherSlot;
            otherSlot = it.next();
            if (otherSlot.queued) {
                if (otherSlot.timestamp != minTimestamp) continue;
                otherSlot.queued = false;
                --this.queued;
                continue;
            }
            it.remove();
        }
        this.lastTimestamp = minTimestamp;
        this.context.advanceTo(minTimestamp);
        this.expected = 0L;
    }

    private class Slot {
        private long timestamp = 0L;
        private boolean queued = false;

        private Slot() {
        }
    }
}

