/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util;

public abstract class DisplayNumberHelper {
    private static final String[] UNITS = new String[]{"", "k", "M", "B"};
    private static final char TIMES = '\u00d7';
    private static final char SUPMINUS = '\u207b';
    private static final char[] SUP = "\u2070\u00b9\u00b2\u00b3\u2074\u2075\u2076\u2077\u2078\u2079".toCharArray();

    public static String eval(double number) {
        if (number < 0.0) {
            return "-" + DisplayNumberHelper.eval(-number);
        }
        if (number == 0.0) {
            return "0";
        }
        if (number >= 1.0) {
            int unit = 0;
            while (number >= 1000.0) {
                number /= 1000.0;
                ++unit;
            }
            if (unit < UNITS.length) {
                return DisplayNumberHelper.formatSinglePoint(number) + UNITS[unit];
            }
            return DisplayNumberHelper.formatLog10(number, 3 * unit);
        }
        if (number >= 0.001) {
            return "" + (double)Math.round(number * 1000.0) / 1000.0;
        }
        return DisplayNumberHelper.formatLog10(number, 0);
    }

    private static String formatLog10(double v, int add) {
        int log10 = (int)Math.floor(Math.log10(v));
        double mantissa = v / Math.pow(10.0, log10);
        return DisplayNumberHelper.formatSinglePoint(mantissa) + '\u00d7' + "10" + DisplayNumberHelper.toSup(log10 + add);
    }

    private static String toSup(int v) {
        StringBuilder builder = new StringBuilder();
        boolean minus = v < 0;
        for (v = Math.abs(v); v > 0; v /= 10) {
            builder.append(SUP[v % 10]);
        }
        if (minus) {
            builder.append('\u207b');
            v = -v;
        }
        return builder.reverse().toString();
    }

    private static String formatSinglePoint(double v) {
        long vx = Math.round(v * 10.0);
        long a = vx / 10L;
        long b = vx % 10L;
        return a + (b > 0L ? "." + b : "");
    }
}

