/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;

public class FilterIterable<T>
implements Iterable<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Iterable<? extends T> input;
    private final Predicate<T> predicate;

    public FilterIterable(Iterable<? extends T> input, Predicate<T> predicate) {
        this.input = input;
        this.predicate = predicate;
    }

    @Override
    public Iterator<T> iterator() {
        return new FilterIterator();
    }

    private class FilterIterator
    implements Iterator<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Iterator<? extends T> iterator;
        private boolean hasNext;
        private T current;

        private FilterIterator() {
            this.iterator = FilterIterable.this.input.iterator();
            this.current = null;
        }

        @Override
        public boolean hasNext() {
            while (!this.hasNext && this.iterator.hasNext()) {
                Object value = this.iterator.next();
                if (!FilterIterable.this.predicate.test(value)) continue;
                this.current = value;
                this.hasNext = true;
            }
            return this.hasNext;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.hasNext = false;
            return this.current;
        }
    }
}

