/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util;

public class HoltWinters {
    private final double alpha;
    private final double beta;
    private volatile long i;
    private volatile double s;
    private volatile double b;

    public HoltWinters(double alpha, double beta) {
        this.alpha = alpha;
        this.beta = beta;
        this.i = 0L;
    }

    public void offer(double value) {
        if (this.i == 0L) {
            this.b = 0.0;
            this.s = value;
        } else {
            double newS = this.alpha * value + (1.0 - this.alpha) * (this.s + this.b);
            double newB = this.beta * (newS - this.s) + (1.0 - this.beta) * this.b;
            this.s = newS;
            this.b = newB;
        }
        ++this.i;
    }

    public double value() {
        return this.s;
    }
}

