/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util;

import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class IntrusivePriorityQueue<E>
extends AbstractQueue<E> {
    private final List<E> queue = new ArrayList();
    private final Comparator<? super E> comparator;
    private final Fields<? super E> fields;

    public IntrusivePriorityQueue(Comparator<? super E> comparator, Fields<? super E> fields) {
        this.comparator = comparator;
        this.fields = fields;
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.queue.add(e);
        this.siftUp(this.queue.size() - 1, e);
        return true;
    }

    @Override
    public E poll() {
        if (this.queue.isEmpty()) {
            return null;
        }
        E e = this.queue.get(0);
        E tmp = this.queue.remove(this.queue.size() - 1);
        if (!this.queue.isEmpty()) {
            this.siftDown(0, tmp);
        }
        return e;
    }

    @Override
    public E peek() {
        return this.queue.isEmpty() ? null : (E)this.queue.get(0);
    }

    @Override
    public boolean remove(Object o) {
        Object e = o;
        int index = this.getIndex(e);
        if (index < 0) {
            return false;
        }
        E tmp = this.queue.remove(this.queue.size() - 1);
        if (index < this.queue.size()) {
            this.updateAt(index, tmp);
        }
        return true;
    }

    public void update(E e) {
        int index = this.getIndex(e);
        if (index < 0) {
            throw new IllegalArgumentException("element not in queue");
        }
        this.updateAt(index, e);
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    private int getIndex(E e) {
        int index = this.fields.getHeapIndex(e);
        if (index < 0 || index >= this.queue.size() || this.queue.get(index) != e) {
            return -1;
        }
        return index;
    }

    private void updateAt(int index, E e) {
        this.siftDown(index, e);
        if (this.queue.get(index) == e) {
            this.siftUp(index, e);
        }
    }

    private void siftUp(int index, E element) {
        int parentIndex;
        E parentElement;
        while (index > 0 && this.comparator.compare(element, parentElement = this.queue.get(parentIndex = (index - 1) / 2)) < 0) {
            this.set(index, parentElement);
            index = parentIndex;
        }
        this.set(index, element);
    }

    private void siftDown(int index, E element) {
        int size = this.queue.size();
        while (index < size / 2) {
            E rightChildElement;
            int childIndex = index * 2 + 1;
            E childElement = this.queue.get(childIndex);
            int rightChildIndex = index * 2 + 2;
            if (rightChildIndex < size && this.comparator.compare(rightChildElement = this.queue.get(rightChildIndex), childElement) < 0) {
                childIndex = rightChildIndex;
                childElement = rightChildElement;
            }
            if (this.comparator.compare(element, childElement) <= 0) break;
            this.set(index, childElement);
            index = childIndex;
        }
        this.set(index, element);
    }

    private void set(int index, E element) {
        this.queue.set(index, element);
        this.fields.setHeapIndex(element, index);
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.queue.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return Collections.unmodifiableCollection(this.queue).iterator();
    }

    @Override
    public Object[] toArray() {
        return this.queue.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.queue.toArray(a);
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.queue.spliterator();
    }

    @Override
    public Stream<E> stream() {
        return this.queue.stream();
    }

    @Override
    public Stream<E> parallelStream() {
        return this.queue.parallelStream();
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        this.queue.forEach(action);
    }

    public static interface Fields<E> {
        public void setHeapIndex(E var1, int var2);

        public int getHeapIndex(E var1);
    }
}

