/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util;

public class LongQueue {
    private int head = 0;
    private int tail = 0;
    private long[] list;

    public LongQueue() {
        this(16);
    }

    public LongQueue(int size) {
        this.list = new long[size];
    }

    public boolean isEmpty() {
        return this.head == this.tail;
    }

    public void enqueue(long v) {
        while (this.next(this.tail) == this.head) {
            this.grow();
        }
        this.list[this.tail] = v;
        this.tail = this.next(this.tail);
    }

    private int next(int index) {
        return (index + 1) % this.list.length;
    }

    private void grow() {
        int size = this.size();
        int newSize = this.list.length + (this.list.length << 1);
        long[] newList = new long[newSize];
        System.arraycopy(this.list, this.head, newList, 0, this.list.length - this.head);
        System.arraycopy(this.list, 0, newList, this.list.length - this.head, this.head);
        this.head = 0;
        this.tail = size;
        this.list = newList;
    }

    public int size() {
        return (this.tail - this.head + this.list.length) % this.list.length;
    }

    public long peek() {
        return this.list[this.head];
    }

    public long dequeue() {
        long e = this.list[this.head];
        this.head = this.next(this.head);
        return e;
    }

    public void clear() {
        this.tail = 0;
        this.head = 0;
    }
}

