/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util;

public abstract class MillisecsHelper {
    private static final String[] UNITS = new String[]{"yr", "wk", "d", "h", "m", "s", "ms"};
    private static final long[] sizes = new long[]{31536000000L, 604800000L, 86400000L, 3600000L, 60000L, 1000L, 1L};

    public static String eval(long x, int precision) {
        if (x == 0L) {
            return "0s";
        }
        long absx = Math.abs(x);
        if (absx < 1000L) {
            return x + "ns";
        }
        if (absx < 999500L) {
            return Math.round((double)x / 1000.0) + "\u00b5s";
        }
        x = Math.round((double)x / 1000000.0);
        if (precision <= 0) {
            precision = Integer.MAX_VALUE;
        }
        int parts = 0;
        int effective = 0;
        StringBuilder sb = new StringBuilder();
        if (x < 0L) {
            sb.append('-');
        }
        x = Math.abs(x);
        for (int i = 0; i < UNITS.length; ++i) {
            long units = x / sizes[i];
            x %= sizes[i];
            if (Math.abs(units) > 0L) {
                if (effective++ > 0) {
                    sb.append(' ');
                }
                sb.append(units).append(UNITS[i]);
            }
            if (effective > 0 && ++parts >= precision) break;
        }
        return sb.toString();
    }
}

