/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import net.intelie.pipes.Row;

public abstract class ObjectHelper {
    public static boolean equals(Object a, Object b) {
        if (a instanceof Iterable && b instanceof Iterable) {
            return ObjectHelper.eqIterables((Iterable)a, (Iterable)b);
        }
        return Objects.equals(a, b);
    }

    private static boolean eqIterables(Iterable a, Iterable b) {
        int sza = ObjectHelper.getSize(a);
        int szb = ObjectHelper.getSize(b);
        if (sza >= 0 && szb >= 0 && sza != szb) {
            return false;
        }
        Iterator ita = a.iterator();
        Iterator itb = b.iterator();
        while (ita.hasNext()) {
            if (itb.hasNext() && ObjectHelper.equals(ita.next(), itb.next())) continue;
            return false;
        }
        return !itb.hasNext();
    }

    private static int getSize(Iterable a) {
        return a instanceof Collection ? ((Collection)a).size() : (a instanceof Row ? ((Row)a).size() : -1);
    }
}

