/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util;

import net.intelie.pipes.PipeException;
import net.intelie.pipes.guava.cache.Cache;
import net.intelie.pipes.guava.cache.CacheBuilder;

public class PipeCache<K, V> {
    private final Cache<K, Slot<V>> cache;
    private final Loader<K, V> loader;

    public PipeCache(int size, Loader<K, V> loader) {
        this.loader = loader;
        this.cache = CacheBuilder.newBuilder().maximumSize(size).weakValues().build();
    }

    public V get(K key) throws PipeException {
        Slot<V> slot = this.cache.getIfPresent(key);
        if (slot == null) {
            try {
                slot = new Slot(this.loader.load(key), null);
                this.cache.put(key, slot);
            }
            catch (Exception e) {
                slot = new Slot(null, e);
                this.cache.put(key, slot);
            }
        }
        if (((Slot)slot).exception != null) {
            throw PipeException.handle((Throwable)((Slot)slot).exception);
        }
        return (V)((Slot)slot).value;
    }

    public static interface Loader<K, V> {
        public V load(K var1) throws PipeException;
    }

    private static class Slot<V> {
        private final V value;
        private final Throwable exception;

        private Slot(V value, Exception exception) {
            this.value = value;
            this.exception = exception;
        }
    }
}

