/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import net.intelie.pipes.Pipe;
import net.intelie.pipes.PipeInstance;
import net.intelie.pipes.RawEvent;
import net.intelie.pipes.RowList;
import net.intelie.pipes.Sink;
import net.intelie.pipes.guava.collect.Iterables;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.LiteralRepresentation;

public class PipeIterable
implements Iterable {
    private final Iterable iterable;
    private final Pipe pipe;

    public PipeIterable(Iterable iterable, Pipe pipe) {
        this.iterable = iterable;
        this.pipe = pipe;
    }

    public Iterator iterator() {
        return new MyIterator();
    }

    public String toString() {
        return "(" + LiteralRepresentation.toString((Type)Type.SEQ, (Object)this.iterable) + " |> [" + this.pipe + "])";
    }

    private class MyIterator
    implements Iterator {
        private final Iterator it;
        private final PipeInstance instance;
        private final Queue Q;
        private boolean finished = false;

        public MyIterator() {
            this.it = PipeIterable.this.iterable.iterator();
            this.Q = new ArrayDeque();
            this.instance = PipeIterable.this.pipe.newInstance(new Sink(){

                public void onEvent(RowFields fields, RowList rows) {
                    Iterables.addAll(MyIterator.this.Q, rows);
                }

                public void onRaw(RawEvent raw) {
                    Iterables.addAll(MyIterator.this.Q, raw);
                }
            });
            this.moveNext();
        }

        private boolean moveNext() {
            if (this.finished) {
                return false;
            }
            while (this.it.hasNext() && this.Q.isEmpty()) {
                this.instance.flow(this.it.next());
            }
            if (this.Q.isEmpty()) {
                this.instance.destroy();
                this.finished = true;
            }
            return !this.Q.isEmpty();
        }

        @Override
        public boolean hasNext() {
            return !this.Q.isEmpty();
        }

        public Object next() {
            if (this.Q.isEmpty()) {
                throw new NoSuchElementException();
            }
            Object next = this.Q.poll();
            if (this.Q.isEmpty()) {
                this.moveNext();
            }
            return next;
        }
    }
}

