/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import net.intelie.pipes.types.Type;

public class RangeIterable
implements Iterable<Double>,
Serializable {
    private static final long serialVersionUID = 0L;
    private final double start;
    private final double step;
    private final double end;

    public RangeIterable(double start, double end, double step) {
        this.start = start;
        this.end = end;
        this.step = step;
    }

    @Override
    public Iterator<Double> iterator() {
        return new MyIterator();
    }

    public String toString() {
        return this.toString(this.start, this.end, this.step);
    }

    public String toString(double start, double end, double step) {
        return String.format((Locale)null, "range(%s, %s, %s)", Type.STRING.cast((Object)start), Type.STRING.cast((Object)end), Type.STRING.cast((Object)step));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RangeIterable that = (RangeIterable)o;
        return Objects.equals(this.start, that.start) && Objects.equals(this.end, that.end) && Objects.equals(this.step, that.step);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end, this.step);
    }

    public double makeNext(double current, double step) {
        return current + step;
    }

    public class MyIterator
    implements Iterator<Double>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private double next;

        public MyIterator() {
            this.next = RangeIterable.this.start;
        }

        @Override
        public boolean hasNext() {
            return RangeIterable.this.step > 0.0 && this.next < RangeIterable.this.end || RangeIterable.this.step < 0.0 && this.next > RangeIterable.this.end;
        }

        @Override
        public Double next() {
            double current = this.next;
            this.next = RangeIterable.this.makeNext(this.next, RangeIterable.this.step);
            return current;
        }
    }
}

