/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class RepeatIterable<T>
implements Iterable<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Iterable<? extends T> iterable;
    private final int count;

    public RepeatIterable(Iterable<? extends T> iterable, int count) {
        this.iterable = iterable;
        this.count = count;
    }

    @Override
    public Iterator<T> iterator() {
        return new RepeatIterator();
    }

    public String toString() {
        return "repeat(" + this.iterable + ", " + this.count + ")";
    }

    private class RepeatIterator
    implements Iterator<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private int iteration = 0;
        private Iterator<? extends T> current = null;

        @Override
        public boolean hasNext() {
            if (this.currentHasNext()) {
                return true;
            }
            while (this.iteration < RepeatIterable.this.count && !this.currentHasNext()) {
                this.current = RepeatIterable.this.iterable.iterator();
                ++this.iteration;
            }
            return this.currentHasNext();
        }

        private boolean currentHasNext() {
            return this.current != null && this.current.hasNext();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.current.next();
        }
    }
}

