/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util;

import java.io.IOException;
import java.lang.reflect.Type;
import net.intelie.pipes.gson.Gson;
import net.intelie.pipes.gson.GsonBuilder;
import net.intelie.pipes.gson.TypeAdapter;
import net.intelie.pipes.gson.stream.JsonReader;
import net.intelie.pipes.gson.stream.JsonToken;
import net.intelie.pipes.gson.stream.JsonWriter;

public abstract class SafeGson {
    private static final Gson gson = SafeGson.create();

    public static String toJson(Object obj) {
        try {
            return gson.toJson(obj);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        try {
            return gson.fromJson(json, clazz);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static Gson create() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter((Type)((Object)Class.class), new ClassSerializer());
        builder.registerTypeAdapter((Type)((Object)Exception.class), new ExceptionSerializer());
        builder.registerTypeAdapter((Type)((Object)Double.class), new DoubleSerializer());
        builder.registerTypeAdapter((Type)((Object)Float.class), new FloatSerializer());
        return builder.create();
    }

    private static class FloatSerializer
    extends TypeAdapter<Number> {
        private FloatSerializer() {
        }

        @Override
        public Number read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return Float.valueOf((float)in.nextDouble());
        }

        @Override
        public void write(JsonWriter out, Number value) throws IOException {
            if (value == null || Double.isNaN(value.doubleValue()) || Double.isInfinite(value.doubleValue())) {
                out.nullValue();
            } else {
                out.value(value);
            }
        }
    }

    private static class DoubleSerializer
    extends TypeAdapter<Number> {
        private DoubleSerializer() {
        }

        @Override
        public Number read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return in.nextDouble();
        }

        @Override
        public void write(JsonWriter out, Number value) throws IOException {
            if (value == null || Double.isNaN(value.doubleValue()) || Double.isInfinite(value.doubleValue())) {
                out.nullValue();
            } else {
                out.value(value);
            }
        }
    }

    private static class ExceptionSerializer
    extends TypeAdapter<Exception> {
        private ExceptionSerializer() {
        }

        @Override
        public void write(JsonWriter out, Exception value) throws IOException {
            if (value != null) {
                out.value(value.getMessage());
            } else {
                out.nullValue();
            }
        }

        @Override
        public Exception read(JsonReader in) throws IOException {
            in.skipValue();
            return null;
        }
    }

    private static class ClassSerializer
    extends TypeAdapter<Class<?>> {
        private ClassSerializer() {
        }

        @Override
        public void write(JsonWriter out, Class<?> value) throws IOException {
            if (value != null) {
                out.value(value.getName());
            } else {
                out.nullValue();
            }
        }

        @Override
        public Class<?> read(JsonReader in) throws IOException {
            try {
                if (in.peek() == JsonToken.NULL) {
                    in.nextNull();
                    return null;
                }
                return Class.forName(in.nextString());
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
        }
    }
}

