/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.intelie.pipes.Property;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.types.FieldInfo;

public class SetPipePropertyVisitor
implements PropertyVisitor {
    private final PropertyVisitor visitor;
    private final Set<String> names;

    public SetPipePropertyVisitor(PropertyVisitor visitor, Iterable<FieldInfo> fields) {
        this.visitor = visitor;
        this.names = StreamSupport.stream(fields.spliterator(), false).map(FieldInfo::name).collect(Collectors.toSet());
    }

    public PropertyVisitor property(Property<?> property) {
        if (this.names.contains(property.name())) {
            return this.newScope();
        }
        return this.visitor.property(property);
    }

    public PropertyVisitor anyProperty() {
        return this.visitor.anyProperty();
    }

    public PropertyVisitor unknown(Object obj) {
        return this.visitor.unknown(obj);
    }

    public PropertyVisitor newScope() {
        return this.visitor.newScope();
    }

    public PropertyVisitor newChildScope() {
        return this.visitor.newChildScope();
    }
}

