/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

public class SliceIterable
implements Iterable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Iterable iterable;
    private final long start;
    private final Long end;
    private final long step;

    public SliceIterable(Iterable iterable, Long start, Long end, Long step) {
        this.iterable = iterable;
        this.start = start != null ? start : 0L;
        this.end = end;
        this.step = step != null ? step : 1L;
    }

    public Iterator iterator() {
        if (this.iterable instanceof List) {
            return new MyListIterator((List)this.iterable, (int)this.start);
        }
        return new MyIterator();
    }

    private class MyListIterator
    implements Iterator {
        private final List list;
        private int index;

        public MyListIterator(List list, int start) {
            this.list = list;
            this.index = start;
        }

        @Override
        public boolean hasNext() {
            return (SliceIterable.this.end == null || (long)this.index < SliceIterable.this.end) && this.index < this.list.size();
        }

        public Object next() {
            Object o = this.list.get(this.index);
            this.index = (int)((long)this.index + SliceIterable.this.step);
            return o;
        }
    }

    private class MyIterator
    implements Iterator {
        private final Iterator it;
        private long count = 0L;

        public MyIterator() {
            this.it = SliceIterable.this.iterable.iterator();
            while (this.it.hasNext() && this.count < SliceIterable.this.start) {
                this.it.next();
                ++this.count;
            }
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext() && (SliceIterable.this.end == null || this.count < SliceIterable.this.end);
        }

        public Object next() {
            Object next = this.it.next();
            ++this.count;
            while ((this.count - SliceIterable.this.start) % SliceIterable.this.step != 0L && this.it.hasNext()) {
                this.it.next();
                ++this.count;
            }
            return next;
        }
    }
}

