/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.intelie.pipes.UnsafeObject;
import net.intelie.pipes.guava.collect.Iterables;
import net.intelie.pipes.time.Period;
import net.intelie.pipes.util.Preconditions;

public class Throttler
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int maxCount;
    private final Iterable<? extends Period> periods;
    private final Map<Object, Slot> map;
    private Slot[] heap;
    private int size;
    private long latest;

    public Throttler(int maxCount, Period period) {
        this(maxCount, Collections.singletonList(period));
    }

    public Throttler(int maxCount, Iterable<? extends Period> periods) {
        Preconditions.checkArgument((Iterables.getFirst(periods, null) != null ? 1 : 0) != 0, (Object)"Must have a non-null first element");
        Preconditions.checkArgument((maxCount > 0 ? 1 : 0) != 0, (Object)"maxCount must be > 0");
        this.maxCount = maxCount;
        this.periods = periods;
        this.heap = this.createHeap(16);
        this.size = 0;
        this.map = new HashMap<Object, Slot>();
        this.latest = 0L;
    }

    private Slot[] createHeap(int n) {
        Slot[] list = (Slot[])Slot[].class.cast(Array.newInstance(Slot.class, n));
        for (int i = 0; i < n; ++i) {
            list[i] = new Slot(i);
        }
        return list;
    }

    public boolean replace(Object value, long ts) {
        if (!this.verifyTimestamp(ts)) {
            return false;
        }
        Slot slot = this.getSlot(value, ts);
        return slot.replace(ts);
    }

    private boolean verifyTimestamp(long ts) {
        if (ts < this.latest) {
            return false;
        }
        this.latest = ts;
        return true;
    }

    public boolean offer(Object value, long ts) {
        if (!this.verifyTimestamp(ts)) {
            return false;
        }
        Slot slot = this.getSlot(value, ts);
        return slot.offer(ts);
    }

    private Slot getSlot(Object value, long ts) {
        while (this.size > 0 && this.heap[0].min() <= ts) {
            this.heap[0].update(ts);
        }
        Slot slot = this.map.get(value);
        if (slot == null) {
            slot = this.acquireSlot(value);
        }
        return slot;
    }

    private Slot acquireSlot(Object value) {
        if (value instanceof UnsafeObject) {
            value = ((UnsafeObject)value).copy();
        }
        this.ensureHeap(this.size);
        Slot slot = this.heap[this.size];
        slot.value = value;
        this.map.put(value, slot);
        ++this.size;
        return slot;
    }

    private void ensureHeap(int newSize) {
        while (this.heap.length <= newSize) {
            int oldSize = this.heap.length;
            this.heap = Arrays.copyOf(this.heap, this.heap.length * 2);
            for (int i = oldSize; i < this.heap.length; ++i) {
                this.heap[i] = new Slot(i);
            }
        }
    }

    public int size() {
        return this.size;
    }

    private int notifyChange(int n) {
        return this.bubbleDown(n);
    }

    private int bubbleDown(int n) {
        int k;
        while ((k = this.min(n, n * 2 + 1, n * 2 + 2)) != n && k < this.size) {
            n = this.swap(n, k);
        }
        return n;
    }

    private int min(int i, int j, int k) {
        return this.min(i, this.min(j, k));
    }

    private int min(int i, int j) {
        return this.less(i, j) ? i : j;
    }

    private boolean less(int i, int j) {
        return i < this.size && (j >= this.size || this.heap[i].min() < this.heap[j].min());
    }

    private int swap(int i, int j) {
        this.heap[i].index = j;
        this.heap[j].index = i;
        Slot tmp = this.heap[i];
        this.heap[i] = this.heap[j];
        this.heap[j] = tmp;
        return j;
    }

    private class Slot {
        public final long[] cache;
        public int begin;
        public int count;
        public Object value;
        public int index;
        public long lastFailedExpiry;
        public Iterator<? extends Period> iterator;
        public Period current;

        public Slot(int index) {
            this.cache = new long[Throttler.this.maxCount];
            this.begin = 0;
            this.count = 0;
            this.lastFailedExpiry = Long.MIN_VALUE;
            this.index = index;
            this.iterator = Throttler.this.periods.iterator();
            this.current = this.iterator.next();
        }

        public void update(long now) {
            while (this.count > 0 && this.cache[this.begin] <= now) {
                this.begin = (this.begin + 1) % Throttler.this.maxCount;
                --this.count;
            }
            if (this.count == 0 && now >= this.lastFailedExpiry) {
                this.release();
            } else {
                Throttler.this.notifyChange(this.index);
            }
        }

        public boolean replace(long ts) {
            boolean value = this.count < Throttler.this.maxCount;
            this.begin = 0;
            this.cache[0] = this.current.add(ts);
            this.count = 1;
            Throttler.this.notifyChange(this.index);
            return value;
        }

        public boolean offer(long ts) {
            if (this.count >= Throttler.this.maxCount) {
                this.lastFailedExpiry = this.current.add(ts);
                return false;
            }
            this.maybeIncreasePeriod(ts);
            this.cache[(this.begin + this.count++) % ((Throttler)Throttler.this).maxCount] = this.current.add(ts);
            Throttler.this.notifyChange(this.index);
            return true;
        }

        private void maybeIncreasePeriod(long ts) {
            if (ts < this.lastFailedExpiry) {
                if (this.iterator != null && this.iterator.hasNext()) {
                    Period candidate = this.iterator.next();
                    if (candidate != null) {
                        this.current = candidate;
                    } else {
                        this.iterator = null;
                    }
                }
            } else {
                this.iterator = Throttler.this.periods.iterator();
                this.current = this.iterator.next();
            }
        }

        public long min() {
            if (this.count > 0) {
                return this.cache[this.begin];
            }
            return this.lastFailedExpiry;
        }

        public void release() {
            this.begin = 0;
            this.count = 0;
            Throttler.this.map.remove(this.value);
            this.value = null;
            Throttler.this.notifyChange(Throttler.this.swap(--Throttler.this.size, this.index));
        }
    }
}

