/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util;

import java.util.Objects;

public class TimeoutString
implements CharSequence {
    private final CharSequence child;
    private final long target;

    private TimeoutString(CharSequence child, long target) {
        this.child = child;
        this.target = target;
    }

    public static TimeoutString wrap(CharSequence child, long timeout) {
        return new TimeoutString(child, System.nanoTime() + timeout * 1000000L);
    }

    public static CharSequence unwrap(CharSequence seq) {
        while (seq instanceof TimeoutString) {
            seq = ((TimeoutString)seq).child;
        }
        return seq;
    }

    public static String unwrapToString(CharSequence seq) {
        if ((seq = TimeoutString.unwrap(seq)) instanceof String || seq == null) {
            return (String)seq;
        }
        return String.valueOf(seq);
    }

    private void checkTarget() {
        if (System.nanoTime() > this.target) {
            throw new IllegalStateException("String operation timeout.");
        }
    }

    @Override
    public int length() {
        this.checkTarget();
        return this.child.length();
    }

    @Override
    public char charAt(int i) {
        this.checkTarget();
        return this.child.charAt(i);
    }

    @Override
    public CharSequence subSequence(int a, int b) {
        this.checkTarget();
        return new TimeoutString(this.child.subSequence(a, b), this.target);
    }

    @Override
    public String toString() {
        return String.valueOf(this.child);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TimeoutString)) {
            return false;
        }
        TimeoutString that = (TimeoutString)o;
        return Objects.equals(this.child, that.child);
    }

    public int hashCode() {
        return Objects.hash(this.child);
    }
}

