/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util;

import java.io.Serializable;
import java.util.Iterator;
import net.intelie.pipes.Evaluable;
import net.intelie.pipes.Scope;

public class TransformIterable<T, Q>
implements Iterable<Q>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Scope scope;
    private final Iterable<? extends T> input;
    private final Evaluable<? extends Q> scalarExpr;

    public TransformIterable(Scope scope, Iterable<? extends T> input, Evaluable<? extends Q> scalarExpr) {
        this.input = input;
        this.scope = scope;
        this.scalarExpr = scalarExpr;
    }

    @Override
    public Iterator<Q> iterator() {
        return new TransformIterator();
    }

    public String toString() {
        return "(" + this.input + " |> " + this.scalarExpr + ")";
    }

    private class TransformIterator
    implements Iterator<Q>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Iterator<? extends T> iterator;

        private TransformIterator() {
            this.iterator = TransformIterable.this.input.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Q next() {
            return TransformIterable.this.scalarExpr.eval(TransformIterable.this.scope, this.iterator.next());
        }
    }
}

