/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.intelie.pipes.Row;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.LiteralRepresentation;

public class UnfoldIterable
implements Iterable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Scope scope;
    private final Object initialState;
    private final Scalar<Row> scalar;

    public UnfoldIterable(Scope scope, Object initialState, Scalar<Row> scalar) {
        this.scope = scope;
        this.initialState = initialState;
        this.scalar = scalar;
    }

    public Iterator iterator() {
        return new MyIterator();
    }

    public String toString() {
        return "unfold(" + LiteralRepresentation.toString((Type)Type.infer((Object)this.initialState), (Object)this.initialState) + ", " + this.scalar + ")";
    }

    private class MyIterator
    implements Iterator {
        private boolean finished = false;
        private Object currentState;
        private Object currentObject;

        private MyIterator() {
            this.currentState = UnfoldIterable.this.initialState;
            this.moveNext();
        }

        private boolean moveNext() {
            if (this.finished) {
                return false;
            }
            Row returned = (Row)UnfoldIterable.this.scalar.eval(UnfoldIterable.this.scope, this.currentState);
            if (returned == null) {
                this.finished = true;
                return true;
            }
            this.currentObject = returned.size() > 0 ? returned.get(0) : null;
            this.currentState = returned.size() > 1 ? returned.get(1) : null;
            this.finished = false;
            return false;
        }

        @Override
        public boolean hasNext() {
            return !this.finished;
        }

        public Object next() {
            if (this.finished) {
                throw new NoSuchElementException();
            }
            Object current = this.currentObject;
            this.moveNext();
            return current;
        }
    }
}

