/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.NavigableSet;
import java.util.PriorityQueue;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.intelie.pipes.util.IntrusivePriorityQueue;
import net.intelie.pipes.util.Preconditions;

public class UniformCompress {
    private int globalPointCount;
    private final IntrusivePriorityQueue<Sequence> globalHeap = new IntrusivePriorityQueue<Sequence>(SequenceHeapComparator.INSTANCE, GlobalHeapFields.INSTANCE);
    private final Collection<Sequence> sequences = new ArrayList<Sequence>();
    private final List<Interval> freeIntervals = new ArrayList<Interval>();

    public Sequence newSequence() {
        Sequence sequence = new Sequence(this.sequences.size());
        this.sequences.add(sequence);
        this.globalHeap.add(sequence);
        return sequence;
    }

    private Interval getFreeInterval() {
        return this.freeIntervals.isEmpty() ? new Interval() : this.freeIntervals.remove(this.freeIntervals.size() - 1);
    }

    private void freeInterval(Interval interval) {
        interval.clearReferences();
        this.freeIntervals.add(interval);
    }

    public void compress(int globalPoints) {
        Interval interval;
        Sequence sequence;
        while (this.globalPointCount > globalPoints && (sequence = this.globalHeap.peek()) != null && (interval = (Interval)sequence.localHeap.peek()) != null) {
            sequence.mergeIntervalInHeap(interval);
        }
    }

    public void output(Consumer<Object> consumer) {
        SequencePointIterator iterator;
        if (this.sequences.isEmpty()) {
            return;
        }
        PriorityQueue iterators = this.sequences.stream().map(SequencePointIterator::new).collect(Collectors.toCollection(() -> new PriorityQueue(this.sequences.size())));
        while ((iterator = (SequencePointIterator)iterators.remove()).current() != null) {
            consumer.accept(iterator.current());
            iterator.next();
            iterators.add(iterator);
        }
    }

    private static int compare(double a1, double a2, double b1, double b2) {
        int result = Double.compare(a1, a2);
        if (result == 0) {
            result = Double.compare(b1, b2);
        }
        return result;
    }

    private static final class LocalHeapFields
    implements IntrusivePriorityQueue.Fields<Interval> {
        public static final LocalHeapFields INSTANCE = new LocalHeapFields();

        private LocalHeapFields() {
        }

        @Override
        public void setHeapIndex(Interval element, int index) {
            element.heapIndex = index;
        }

        @Override
        public int getHeapIndex(Interval element) {
            return element.heapIndex;
        }
    }

    private static final class GlobalHeapFields
    implements IntrusivePriorityQueue.Fields<Sequence> {
        public static final GlobalHeapFields INSTANCE = new GlobalHeapFields();

        private GlobalHeapFields() {
        }

        @Override
        public void setHeapIndex(Sequence element, int index) {
            element.heapIndex = index;
        }

        @Override
        public int getHeapIndex(Sequence element) {
            return element.heapIndex;
        }
    }

    private static final class IntervalListComparator
    implements Comparator<Interval> {
        public static final IntervalListComparator INSTANCE = new IntervalListComparator();

        private IntervalListComparator() {
        }

        @Override
        public int compare(Interval o1, Interval o2) {
            if (o1.maxXX < o2.minXX) {
                return -1;
            }
            if (o1.minXX > o2.maxXX) {
                return 1;
            }
            return 0;
        }
    }

    private static final class IntervalHeapComparator
    implements Comparator<Interval> {
        public static final IntervalHeapComparator INSTANCE = new IntervalHeapComparator();

        private IntervalHeapComparator() {
        }

        @Override
        public int compare(Interval o1, Interval o2) {
            int result = Double.compare(o1.cachedDistance, o2.cachedDistance);
            if (result == 0) {
                result = Double.compare(o1.minXX, o2.minXX);
            }
            return result;
        }
    }

    private static final class SequenceHeapComparator
    implements Comparator<Sequence> {
        public static final SequenceHeapComparator INSTANCE = new SequenceHeapComparator();

        private SequenceHeapComparator() {
        }

        @Override
        public int compare(Sequence o1, Sequence o2) {
            Interval i1 = (Interval)o1.localHeap.peek();
            Interval i2 = (Interval)o2.localHeap.peek();
            if (i1 == null || i2 == null) {
                return Boolean.compare(i1 == null, i2 == null);
            }
            int result = IntervalHeapComparator.INSTANCE.compare(i1, i2);
            if (result == 0) {
                result = Integer.compare(o1.sequenceIndex, o2.sequenceIndex);
            }
            return result;
        }
    }

    private static class SequencePointIterator
    implements Comparable<SequencePointIterator> {
        private double currentX;
        private Object currentO;
        private int currentI;
        private final double[] currentXs = new double[4];
        private final Object[] currentOs = new Object[4];
        private int currentLength;
        private Interval interval;
        private final int sequenceIndex;

        public SequencePointIterator(Sequence sequence) {
            this.sequenceIndex = sequence.sequenceIndex;
            this.nextInterval(sequence.first);
        }

        public Object current() {
            return this.currentO;
        }

        public void next() {
            if (++this.currentI < this.currentLength) {
                this.currentX = this.currentXs[this.currentI];
                this.currentO = this.currentOs[this.currentI];
            } else {
                this.nextInterval(this.interval.next);
            }
        }

        private void nextInterval(Interval nextInterval) {
            this.currentI = 0;
            this.currentLength = 0;
            this.interval = nextInterval;
            if (this.interval == null) {
                this.currentX = Double.POSITIVE_INFINITY;
                this.currentO = null;
                return;
            }
            if (this.interval.minXO != null) {
                this.add(this.interval.minXX, this.interval.minXO);
            }
            if (UniformCompress.compare(this.interval.minYX, this.interval.maxYX, this.interval.minYY, this.interval.maxYY) <= 0) {
                if (this.interval.minYO != this.interval.minXO) {
                    this.add(this.interval.minYX, this.interval.minYO);
                }
                if (this.interval.maxYO != this.interval.minYO) {
                    this.add(this.interval.maxYX, this.interval.maxYO);
                }
                if (this.interval.maxXO != this.interval.maxYO && this.interval.maxXO != null) {
                    this.add(this.interval.maxXX, this.interval.maxXO);
                }
            } else {
                if (this.interval.maxYO != this.interval.minXO) {
                    this.add(this.interval.maxYX, this.interval.maxYO);
                }
                if (this.interval.minYO != this.interval.maxYO) {
                    this.add(this.interval.minYX, this.interval.minYO);
                }
                if (this.interval.maxXO != this.interval.minYO && this.interval.maxXO != null) {
                    this.add(this.interval.maxXX, this.interval.maxXO);
                }
            }
            assert (this.currentLength == this.interval.pointCount);
            this.currentX = this.currentXs[this.currentI];
            this.currentO = this.currentOs[this.currentI];
        }

        private void add(double x, Object o) {
            this.currentXs[this.currentLength] = x;
            this.currentOs[this.currentLength] = o;
            ++this.currentLength;
        }

        @Override
        public int compareTo(SequencePointIterator o) {
            int result = Double.compare(this.currentX, o.currentX);
            if (result == 0) {
                result = Boolean.compare(this.currentO == null, o.currentO == null);
            }
            if (result == 0) {
                result = Integer.compare(this.sequenceIndex, o.sequenceIndex);
            }
            return result;
        }
    }

    private static class Interval {
        private double cachedDistance;
        private int heapIndex;
        private double minXX;
        private double maxXX;
        private double minXY;
        private double maxXY;
        private Object minXO;
        private Object maxXO;
        private double minYX;
        private double maxYX;
        private double minYY;
        private double maxYY;
        private Object minYO;
        private Object maxYO;
        private int pointCount;
        private Interval prev;
        private Interval next;

        private Interval() {
        }

        private double midX() {
            return this.minXX / 2.0 + this.maxXX / 2.0;
        }

        private double size() {
            return this.maxXX - this.minXX;
        }

        private void cacheDistance() {
            this.cachedDistance = this.next.midX() - this.midX();
        }

        public void reset(double x, double y, Object object) {
            this.minXX = x;
            this.maxXX = x;
            this.minXY = y;
            this.maxXY = y;
            this.minXO = object;
            this.maxXO = object;
            this.minYX = x;
            this.maxYX = x;
            this.minYY = y;
            this.maxYY = y;
            this.minYO = object;
            this.maxYO = object;
            this.pointCount = 1;
            this.prev = null;
            this.next = null;
        }

        private void clearReferences() {
            this.minXO = null;
            this.maxXO = null;
            this.minYO = null;
            this.maxYO = null;
            this.prev = null;
            this.next = null;
        }

        public void merge(Interval other) {
            if (UniformCompress.compare(other.minXX, this.minXX, other.minXY, this.minXY) <= 0) {
                this.minXX = other.minXX;
                this.minXY = other.minXY;
                this.minXO = other.minXO;
            }
            if (UniformCompress.compare(other.maxXX, this.maxXX, other.maxXY, this.maxXY) >= 0) {
                this.maxXX = other.maxXX;
                this.maxXY = other.maxXY;
                this.maxXO = other.maxXO;
            }
            if (UniformCompress.compare(other.minYY, this.minYY, other.minYX, this.minYX) <= 0) {
                this.minYX = other.minYX;
                this.minYY = other.minYY;
                this.minYO = other.minYO;
            }
            if (UniformCompress.compare(other.maxYY, this.maxYY, other.maxYX, this.maxYX) >= 0) {
                this.maxYX = other.maxYX;
                this.maxYY = other.maxYY;
                this.maxYO = other.maxYO;
            }
            this.countPoints();
        }

        private void countPoints() {
            int n = this.pointCount = this.minXO != null ? 1 : 0;
            if (UniformCompress.compare(this.minYX, this.maxYX, this.minYY, this.maxYY) <= 0) {
                if (this.minYO != this.minXO) {
                    ++this.pointCount;
                }
                if (this.maxYO != this.minYO) {
                    ++this.pointCount;
                }
                if (this.maxXO != this.maxYO && this.maxXO != null) {
                    ++this.pointCount;
                }
            } else {
                if (this.maxYO != this.minXO) {
                    ++this.pointCount;
                }
                if (this.minYO != this.maxYO) {
                    ++this.pointCount;
                }
                if (this.maxXO != this.minYO && this.maxXO != null) {
                    ++this.pointCount;
                }
            }
        }
    }

    public class Sequence {
        private int localPointCount;
        private int heapIndex;
        private final IntrusivePriorityQueue<Interval> localHeap = new IntrusivePriorityQueue<Interval>(IntervalHeapComparator.INSTANCE, LocalHeapFields.INSTANCE);
        private NavigableSet<Interval> intervals;
        private Interval first;
        private Interval last;
        private final int sequenceIndex;

        private Sequence(int sequenceIndex) {
            this.sequenceIndex = sequenceIndex;
        }

        public void addPoint(double x, double y, Object object) {
            Interval nextInterval;
            Interval prevInterval;
            Preconditions.checkArgument((!Double.isNaN(x) ? 1 : 0) != 0, (Object)"point X is NaN");
            Preconditions.checkArgument((!Double.isNaN(y) ? 1 : 0) != 0, (Object)"point Y is NaN");
            Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)"object is null");
            Interval interval = UniformCompress.this.getFreeInterval();
            interval.reset(x, y, object);
            if (this.last != null && x >= this.last.minXX) {
                prevInterval = this.last;
                nextInterval = x > this.last.maxXX ? null : this.last;
            } else if (this.first != null && x <= this.first.maxXX) {
                prevInterval = x < this.first.minXX ? null : this.first;
                nextInterval = this.first;
            } else if (this.first == null && this.last == null) {
                prevInterval = null;
                nextInterval = null;
            } else {
                if (this.intervals == null) {
                    this.initIntervals();
                }
                prevInterval = this.intervals.floor(interval);
                nextInterval = this.intervals.ceiling(interval);
            }
            if (prevInterval == nextInterval && prevInterval != null) {
                this.mergeInterval(prevInterval, interval);
                return;
            }
            if (this.intervals != null) {
                this.intervals.add(interval);
            }
            this.addPointCount(interval);
            this.updateIntervalPairs(prevInterval, interval, nextInterval);
        }

        private void initIntervals() {
            this.intervals = new TreeSet<Interval>(IntervalListComparator.INSTANCE);
            Interval interval = this.first;
            while (interval != null) {
                this.intervals.add(interval);
                interval = interval.next;
            }
        }

        public void compress(int localPoints) {
            Interval interval;
            while (this.localPointCount > localPoints && (interval = this.localHeap.peek()) != null) {
                this.mergeIntervalInHeap(interval);
            }
        }

        private void mergeIntervalInHeap(Interval prevInterval) {
            Interval interval = prevInterval.next;
            Interval nextInterval = interval.next;
            if (this.intervals != null) {
                this.intervals.remove(interval);
            }
            this.subPointCount(interval);
            this.removeIntervalFromHeap(interval);
            this.mergeInterval(prevInterval, interval);
            this.updateIntervalPairs(prevInterval.prev, prevInterval, nextInterval);
        }

        private void mergeInterval(Interval intoInterval, Interval fromInterval) {
            this.subPointCount(intoInterval);
            intoInterval.merge(fromInterval);
            this.addPointCount(intoInterval);
            UniformCompress.this.freeInterval(fromInterval);
        }

        private void removeIntervalFromHeap(Interval interval) {
            if (interval.next != null) {
                this.localHeap.remove(interval);
                interval.next = null;
            }
        }

        private void updateIntervalPairs(Interval prevInterval, Interval interval, Interval nextInterval) {
            if (prevInterval == null) {
                this.first = interval;
            }
            if (nextInterval == null) {
                this.last = interval;
            }
            this.updateIntervalPair(prevInterval, interval);
            this.updateIntervalPair(interval, nextInterval);
            UniformCompress.this.globalHeap.update(this);
        }

        private void updateIntervalPair(Interval prevInterval, Interval nextInterval) {
            if (prevInterval == null) {
                return;
            }
            boolean add = prevInterval.next == null;
            prevInterval.next = nextInterval;
            if (nextInterval != null) {
                nextInterval.prev = prevInterval;
                prevInterval.cacheDistance();
            }
            if (add) {
                if (nextInterval != null) {
                    this.localHeap.add(prevInterval);
                }
            } else if (nextInterval != null) {
                this.localHeap.update(prevInterval);
            } else {
                this.localHeap.remove(prevInterval);
            }
            if (nextInterval != null) {
                this.dropUninterestingPoints(prevInterval, nextInterval);
            }
        }

        private void dropUninterestingPoints(Interval prevInterval, Interval nextInterval) {
            if (prevInterval.maxXO == null && nextInterval.minXO == null) {
                return;
            }
            if (nextInterval.minXX - prevInterval.maxXX > Math.max(prevInterval.size(), nextInterval.size())) {
                return;
            }
            this.subPointCount(prevInterval);
            this.subPointCount(nextInterval);
            prevInterval.maxXO = null;
            nextInterval.minXO = null;
            prevInterval.countPoints();
            nextInterval.countPoints();
            this.addPointCount(prevInterval);
            this.addPointCount(nextInterval);
        }

        private void addPointCount(Interval interval) {
            this.localPointCount += interval.pointCount;
            UniformCompress.this.globalPointCount = UniformCompress.this.globalPointCount + interval.pointCount;
        }

        private void subPointCount(Interval interval) {
            this.localPointCount -= interval.pointCount;
            UniformCompress.this.globalPointCount = UniformCompress.this.globalPointCount - interval.pointCount;
        }
    }
}

