/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

public class UpdateHeap<V>
implements Iterable<V> {
    private final Comparator<V> comparator;
    private final HashMap<V, Entry> map;
    private Entry[] heap;
    private int size;

    public UpdateHeap() {
        this(null);
    }

    public UpdateHeap(Comparator<V> comparator) {
        this.comparator = comparator;
        this.map = new HashMap();
        this.heap = this.createArray();
        this.size = 0;
    }

    private Entry[] createArray() {
        Entry[] initial = (Entry[])Entry[].class.cast(Array.newInstance(Entry.class, 16));
        for (int i = 0; i < initial.length; ++i) {
            initial[i] = new Entry(i);
        }
        return initial;
    }

    public void addOrUpdate(V value) {
        if (value == null) {
            throw new IllegalArgumentException("UpdateHeap does not support null values");
        }
        Entry entry = this.map.get(value);
        if (entry != null) {
            this.notifyChange(entry.index);
        } else {
            this.ensureHeap(this.size);
            entry = this.acquireItem(value);
            this.bubbleUp(entry.index);
            this.map.put((Entry)value, entry);
        }
    }

    public V remove(V value) {
        Entry entry = this.map.remove(value);
        if (entry != null) {
            return this.removeAt(entry.index);
        }
        return null;
    }

    private Entry acquireItem(V obj) {
        Entry entry = this.heap[this.size];
        entry.obj = obj;
        ++this.size;
        return entry;
    }

    private void ensureHeap(int newSize) {
        while (this.heap.length <= newSize) {
            int oldSize = this.heap.length;
            this.heap = Arrays.copyOf(this.heap, this.heap.length * 2);
            for (int i = oldSize; i < this.heap.length; ++i) {
                this.heap[i] = new Entry(i);
            }
        }
    }

    public V top() {
        return (V)this.heap[0].obj;
    }

    @Override
    public Iterator<V> iterator() {
        return new Iterator<V>(){
            private final Iterator<V> it;
            private V last;
            {
                this.it = UpdateHeap.this.map.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public V next() {
                this.last = this.it.next();
                return this.last;
            }

            @Override
            public void remove() {
                if (this.last == null) {
                    throw new IllegalStateException("Must call next() before removing");
                }
                Entry entry = (Entry)UpdateHeap.this.map.get(this.last);
                this.it.remove();
                UpdateHeap.this.removeAt(entry.index);
            }
        };
    }

    private V removeAt(int idx) {
        this.swap(idx, --this.size);
        this.bubbleDown(idx);
        Object obj = this.heap[this.size].obj;
        this.heap[this.size].obj = null;
        return (V)obj;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    private int notifyChange(int n) {
        return this.bubbleDown(this.bubbleUp(n));
    }

    private int bubbleUp(int n) {
        while (this.less(n, (n - 1) / 2)) {
            n = this.swap(n, (n - 1) / 2);
        }
        return n;
    }

    private int bubbleDown(int n) {
        int k;
        while ((k = this.min(n, n * 2 + 1, n * 2 + 2)) != n && k < this.size) {
            n = this.swap(n, k);
        }
        return n;
    }

    private int min(int i, int j, int k) {
        return this.min(i, this.min(j, k));
    }

    private int min(int i, int j) {
        return this.less(i, j) ? i : j;
    }

    private boolean less(int i, int j) {
        return i < this.size && (j >= this.size || this.compare(i, j) < 0);
    }

    private int compare(int i, int j) {
        if (this.comparator != null) {
            return this.comparator.compare(this.heap[i].obj, this.heap[j].obj);
        }
        return ((Comparable)this.heap[i].obj).compareTo(this.heap[j].obj);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(this.heap[i].obj);
        }
        return builder.append("]").toString();
    }

    private int swap(int i, int j) {
        this.heap[i].index = j;
        this.heap[j].index = i;
        Entry tmp = this.heap[i];
        this.heap[i] = this.heap[j];
        this.heap[j] = tmp;
        return j;
    }

    private class Entry {
        private V obj;
        private int index;

        public Entry(int index) {
            this.index = index;
        }
    }
}

