/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util.pip;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import net.intelie.pipes.guava.base.Function;
import net.intelie.pipes.guava.collect.Iterators;
import net.intelie.pipes.guava.primitives.Longs;
import net.intelie.pipes.util.pip.Distance;
import net.intelie.pipes.util.pip.Pip;
import net.intelie.pipes.util.pip.SimplePip;

public class MultiPip<V>
implements Iterable<V> {
    private final Distance<V> distance;
    private Slot[] heap;
    private int size = 0;
    private int slotCount = 0;
    private long globalOrder = 0L;
    private long slotGlobalOrder = 0L;

    public static <V> MultiPip<V> create(Distance<V> distance) {
        return new MultiPip<V>(distance);
    }

    public MultiPip(Distance<V> distance) {
        this.distance = distance;
        this.heap = (Slot[])Slot[].class.cast(Array.newInstance(Slot.class, 16));
    }

    private void ensureHeap(int newSize) {
        while (this.heap.length <= newSize) {
            this.heap = Arrays.copyOf(this.heap, this.heap.length * 2);
        }
    }

    public V removeMin() {
        if (this.slotCount == 0) {
            return null;
        }
        return this.heap[0].removeMin();
    }

    public double minValue() {
        if (this.slotCount == 0) {
            return Double.MAX_VALUE;
        }
        return this.heap[0].minValue();
    }

    public int size() {
        return this.size;
    }

    public Pip<V> requireSlot() {
        return new Slot();
    }

    private int notifyChange(int n) {
        return this.bubbleDown(this.bubbleUp(n));
    }

    private int bubbleUp(int n) {
        while (this.less(n, (n - 1) / 2)) {
            n = this.swap(n, (n - 1) / 2);
        }
        return n;
    }

    private int bubbleDown(int n) {
        int k;
        while ((k = this.min(n, n * 2 + 1, n * 2 + 2)) != n && k < this.heap.length) {
            n = this.swap(n, k);
        }
        return n;
    }

    private int min(int i, int j, int k) {
        return this.min(i, this.min(j, k));
    }

    private int min(int i, int j) {
        return this.less(i, j) ? i : j;
    }

    private boolean less(int i, int j) {
        return i < this.slotCount && (j >= this.slotCount || (this.heap[i].minValue() != this.heap[j].minValue() ? this.heap[i].minValue() < this.heap[j].minValue() : this.heap[i].order < this.heap[j].order));
    }

    private void removeAt(int idx) {
        this.swap(idx, --this.slotCount);
        this.heap[this.slotCount] = null;
        if (this.slotCount > 0) {
            this.bubbleDown(idx);
        }
    }

    @Override
    public Iterator<V> iterator() {
        ArrayList<Iterator<Point>> slots = new ArrayList<Iterator<Point>>();
        for (int i = 0; i < this.slotCount; ++i) {
            slots.add(this.heap[i].pointIterator());
        }
        return Iterators.transform(Iterators.mergeSorted(slots, new PointComparator()), new PointToV());
    }

    private int swap(int i, int j) {
        this.heap[i].index = j;
        this.heap[j].index = i;
        Slot tmp = this.heap[i];
        this.heap[i] = this.heap[j];
        this.heap[j] = tmp;
        return j;
    }

    private class PointComparator
    implements Comparator<Point> {
        private PointComparator() {
        }

        @Override
        public int compare(Point o1, Point o2) {
            return Longs.compare(o1.order, o2.order);
        }
    }

    private class PointToV
    implements Function<Point, V> {
        private PointToV() {
        }

        @Override
        public V apply(Point input) {
            return input.value;
        }
    }

    public class Slot
    implements Pip<V> {
        private final SimplePip<Point> child;
        private int index;
        private long order;

        public Slot() {
            this.child = new SimplePip<Point>(new PointDistance());
            this.index = -1;
        }

        @Override
        public int size() {
            return this.child.size();
        }

        @Override
        public double minValue() {
            return this.child.minValue();
        }

        @Override
        public void offer(V value) {
            if (this.index == -1) {
                MultiPip.this.ensureHeap(MultiPip.this.slotCount);
                ((MultiPip)MultiPip.this).heap[((MultiPip)MultiPip.this).slotCount] = this;
                this.index = MultiPip.this.slotCount;
                this.order = MultiPip.this.slotGlobalOrder++;
                MultiPip.this.slotCount++;
            }
            MultiPip.this.size++;
            this.child.offer(new Point(value));
            MultiPip.this.notifyChange(this.index);
        }

        @Override
        public V removeMin() {
            MultiPip.this.size--;
            Object obj = this.child.removeMin().value;
            if (this.child.size() > 0) {
                MultiPip.this.notifyChange(this.index);
            } else {
                MultiPip.this.removeAt(this.index);
                this.index = -1;
            }
            return obj;
        }

        @Override
        public Iterator<V> iterator() {
            return Iterators.transform(this.pointIterator(), new PointToV());
        }

        public Iterator<Point> pointIterator() {
            return this.child.iterator();
        }
    }

    public class PointDistance
    implements Distance<Point> {
        @Override
        public double calculate(Point a, Point b, Point c) {
            return MultiPip.this.distance.calculate(a.value, b.value, c.value);
        }
    }

    public class Point {
        private final long order;
        private final V value;

        public Point(V value) {
            this.value = value;
            this.order = MultiPip.this.globalOrder++;
        }
    }
}

