/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util.pip;

import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.intelie.pipes.util.pip.Distance;

public class PipPoint<T> {
    private final T obj;
    private final double x;
    private final double y;

    public PipPoint(T obj, double x, double y) {
        this.obj = obj;
        this.x = x;
        this.y = y;
    }

    public static <T> Distance<PipPoint<T>> distance() {
        return new PointDistance();
    }

    public static <T> Iterable<T> unpack(Iterable<PipPoint<T>> it) {
        return StreamSupport.stream(it.spliterator(), false).map(input -> input.obj).collect(Collectors.toList());
    }

    public static class PointDistance<T>
    implements Distance<PipPoint<T>> {
        @Override
        public double calculate(PipPoint<T> a, PipPoint<T> b, PipPoint<T> c) {
            if (Math.abs(((PipPoint)a).x - ((PipPoint)b).x) < 1.0E-6 || Math.abs(((PipPoint)b).x - ((PipPoint)c).x) < 1.0E-6) {
                return 0.0;
            }
            return Math.abs((((PipPoint)a).y + (((PipPoint)c).y - ((PipPoint)a).y) * (((PipPoint)b).x - ((PipPoint)a).x) / (((PipPoint)c).x - ((PipPoint)a).x) - ((PipPoint)b).y) * (((PipPoint)c).x - ((PipPoint)a).x));
        }
    }
}

