/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util.pip;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.intelie.pipes.util.Preconditions;
import net.intelie.pipes.util.pip.Distance;
import net.intelie.pipes.util.pip.Pip;

public class SimplePip<V>
implements Pip<V> {
    private final Distance<V> distance;
    private PipItem[] heap;
    private PipItem head;
    private PipItem tail;
    private int size;
    private long globalOrder;

    public static <V> SimplePip<V> create(Distance<V> distance) {
        return new SimplePip<V>(distance);
    }

    public SimplePip(Distance<V> distance) {
        this.distance = distance;
        this.heap = this.createHeap(16);
        this.head = null;
        this.tail = null;
        this.size = 0;
        this.globalOrder = 0L;
    }

    private PipItem[] createHeap(int n) {
        PipItem[] list = (PipItem[])PipItem[].class.cast(Array.newInstance(PipItem.class, n));
        for (int i = 0; i < n; ++i) {
            list[i] = new PipItem(i);
        }
        return list;
    }

    @Override
    public void offer(V value) {
        this.tail = this.acquireItem(value).putAfter(this.tail);
        if (this.head == null) {
            this.head = this.tail;
        }
    }

    private PipItem acquireItem(V value) {
        this.ensureHeap(this.size);
        PipItem item = this.heap[this.size];
        item.value = value;
        item.order = this.globalOrder++;
        ++this.size;
        return item;
    }

    private void ensureHeap(int newSize) {
        while (this.heap.length <= newSize) {
            int oldSize = this.heap.length;
            this.heap = Arrays.copyOf(this.heap, this.heap.length * 2);
            for (int i = oldSize; i < this.heap.length; ++i) {
                this.heap[i] = new PipItem(i);
            }
        }
    }

    @Override
    public double minValue() {
        return this.heap[0].cache;
    }

    @Override
    public V removeMin() {
        return this.removeAt(0);
    }

    private V removeAt(int idx) {
        this.swap(idx, --this.size);
        this.bubbleDown(idx);
        return this.heap[this.size].recycle();
    }

    @Override
    public Iterator<V> iterator() {
        return new PipIterator(this.head);
    }

    @Override
    public int size() {
        return this.size;
    }

    private int notifyChange(int n) {
        return this.bubbleDown(this.bubbleUp(n));
    }

    private int bubbleUp(int n) {
        while (this.less(n, (n - 1) / 2)) {
            n = this.swap(n, (n - 1) / 2);
        }
        return n;
    }

    private int bubbleDown(int n) {
        int k;
        while ((k = this.min(n, n * 2 + 1, n * 2 + 2)) != n && k < this.size) {
            n = this.swap(n, k);
        }
        return n;
    }

    private int min(int i, int j, int k) {
        return this.min(i, this.min(j, k));
    }

    private int min(int i, int j) {
        return this.less(i, j) ? i : j;
    }

    private boolean less(int i, int j) {
        return i < this.size && (j >= this.size || (this.heap[i].cache != this.heap[j].cache ? this.heap[i].cache < this.heap[j].cache : this.heap[i].order < this.heap[j].order));
    }

    private int swap(int i, int j) {
        this.heap[i].index = j;
        this.heap[j].index = i;
        PipItem tmp = this.heap[i];
        this.heap[i] = this.heap[j];
        this.heap[j] = tmp;
        return j;
    }

    private class PipIterator
    implements Iterator<V> {
        private volatile PipItem prev;
        private volatile PipItem current;

        public PipIterator(PipItem head) {
            this.current = head;
            this.prev = null;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.prev = this.current;
            Object value = this.current.value;
            this.current = this.current.next;
            return value;
        }

        @Override
        public void remove() {
            Preconditions.checkState((this.prev != null ? 1 : 0) != 0, (Object)"No element to remove");
            SimplePip.this.removeAt(this.prev.index);
            this.prev = null;
        }
    }

    private class PipItem {
        public double cache = Double.MAX_VALUE;
        public V value;
        public int index;
        public long order;
        public PipItem prev;
        public PipItem next;

        public PipItem(int index) {
            this.index = index;
        }

        public void updateCache() {
            this.cache = this.prev == null || this.next == null ? Double.MAX_VALUE : SimplePip.this.distance.calculate(this.prev.value, this.value, this.next.value);
            SimplePip.this.notifyChange(this.index);
        }

        public PipItem putAfter(PipItem tail) {
            if (tail != null) {
                tail.next = this;
                tail.updateCache();
            }
            this.prev = tail;
            this.updateCache();
            return this;
        }

        public V recycle() {
            if (this.prev != null) {
                this.prev.next = this.next;
                this.prev.updateCache();
            } else {
                SimplePip.this.head = this.next;
            }
            if (this.next != null) {
                this.next.prev = this.prev;
                this.next.updateCache();
            } else {
                SimplePip.this.tail = this.prev;
            }
            return this.clear();
        }

        public V clear() {
            this.order = 0L;
            this.next = null;
            this.prev = null;
            this.cache = Double.MAX_VALUE;
            Object ret = this.value;
            this.value = null;
            return ret;
        }
    }
}

