/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util.regex;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.intelie.pipes.util.regex.MatchResult;
import net.intelie.pipes.util.regex.Pattern;

public class Matcher
implements MatchResult {
    private java.util.regex.Matcher matcher;
    private Pattern parentPattern;

    Matcher(Pattern parentPattern, java.util.regex.Matcher matcher) {
        this.parentPattern = parentPattern;
        this.matcher = matcher;
    }

    Matcher(Pattern parentPattern, CharSequence input) {
        this.parentPattern = parentPattern;
        this.matcher = parentPattern.pattern().matcher(input);
    }

    public java.util.regex.Pattern standardPattern() {
        return this.matcher.pattern();
    }

    public Pattern namedPattern() {
        return this.parentPattern;
    }

    public Matcher usePattern(Pattern newPattern) {
        if (newPattern == null) {
            throw new IllegalArgumentException("newPattern cannot be null");
        }
        this.parentPattern = newPattern;
        this.matcher.usePattern(newPattern.pattern());
        return this;
    }

    public Matcher reset() {
        this.matcher.reset();
        return this;
    }

    public Matcher reset(CharSequence input) {
        this.matcher.reset(input);
        return this;
    }

    public boolean matches() {
        return this.matcher.matches();
    }

    public MatchResult toMatchResult() {
        return new Matcher(this.parentPattern, this.matcher);
    }

    public boolean find() {
        return this.matcher.find();
    }

    public boolean find(int start) {
        return this.matcher.find(start);
    }

    public boolean lookingAt() {
        return this.matcher.lookingAt();
    }

    public Matcher appendReplacement(StringBuffer sb, String replacement) {
        this.matcher.appendReplacement(sb, this.parentPattern.replaceProperties(replacement));
        return this;
    }

    public StringBuffer appendTail(StringBuffer sb) {
        return this.matcher.appendTail(sb);
    }

    @Override
    public String group() {
        return this.matcher.group();
    }

    @Override
    public String group(int group) {
        return this.matcher.group(group);
    }

    @Override
    public int groupCount() {
        return this.matcher.groupCount();
    }

    @Override
    public List<String> orderedGroups() {
        int groupCount = this.groupCount();
        ArrayList<String> groups = new ArrayList<String>(groupCount);
        for (int i = 1; i <= groupCount; ++i) {
            groups.add(this.group(i));
        }
        return groups;
    }

    @Override
    public String group(String groupName) {
        int idx = this.groupIndex(groupName);
        if (idx < 0) {
            throw new IndexOutOfBoundsException("No group \"" + groupName + "\"");
        }
        return this.group(idx);
    }

    @Override
    public List<Map<String, String>> namedGroups() {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        List<String> groupNames = this.parentPattern.groupNames();
        if (groupNames.isEmpty()) {
            return result;
        }
        int nextIndex = 0;
        while (this.matcher.find(nextIndex)) {
            LinkedHashMap<String, String> matches = new LinkedHashMap<String, String>();
            for (String groupName : groupNames) {
                String groupValue = this.matcher.group(this.groupIndex(groupName));
                matches.put(groupName, groupValue);
                nextIndex = this.matcher.end();
            }
            result.add(matches);
        }
        return result;
    }

    private int groupIndex(String groupName) {
        int idx = this.parentPattern.indexOf(groupName);
        return idx > -1 ? idx + 1 : -1;
    }

    @Override
    public int start() {
        return this.matcher.start();
    }

    @Override
    public int start(int group) {
        return this.matcher.start(group);
    }

    @Override
    public int start(String groupName) {
        return this.start(this.groupIndex(groupName));
    }

    @Override
    public int end() {
        return this.matcher.end();
    }

    @Override
    public int end(int group) {
        return this.matcher.end(group);
    }

    @Override
    public int end(String groupName) {
        return this.end(this.groupIndex(groupName));
    }

    public Matcher region(int start, int end) {
        this.matcher.region(start, end);
        return this;
    }

    public int regionEnd() {
        return this.matcher.regionEnd();
    }

    public int regionStart() {
        return this.matcher.regionStart();
    }

    public boolean hitEnd() {
        return this.matcher.hitEnd();
    }

    public boolean requireEnd() {
        return this.matcher.requireEnd();
    }

    public boolean hasAnchoringBounds() {
        return this.matcher.hasAnchoringBounds();
    }

    public boolean hasTransparentBounds() {
        return this.matcher.hasTransparentBounds();
    }

    public String replaceAll(String replacement) {
        String r = this.parentPattern.replaceProperties(replacement);
        return this.matcher.replaceAll(r);
    }

    public String replaceFirst(String replacement) {
        return this.matcher.replaceFirst(this.parentPattern.replaceProperties(replacement));
    }

    public Matcher useAnchoringBounds(boolean b) {
        this.matcher.useAnchoringBounds(b);
        return this;
    }

    public Matcher useTransparentBounds(boolean b) {
        this.matcher.useTransparentBounds(b);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Matcher)) {
            return false;
        }
        Matcher other = (Matcher)obj;
        if (!this.parentPattern.equals(other.parentPattern)) {
            return false;
        }
        return this.matcher.equals(other.matcher);
    }

    public int hashCode() {
        return this.parentPattern.hashCode() ^ this.matcher.hashCode();
    }

    public String toString() {
        return this.matcher.toString();
    }
}

