/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util.regex;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import net.intelie.pipes.util.regex.GroupInfo;
import net.intelie.pipes.util.regex.Matcher;

public class Pattern
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String NAME_PATTERN = "[^!=].*?";
    private static final java.util.regex.Pattern NAMED_GROUP_PATTERN = java.util.regex.Pattern.compile("\\(\\?<([^!=].*?)>", 32);
    private static final java.util.regex.Pattern BACKREF_NAMED_GROUP_PATTERN = java.util.regex.Pattern.compile("\\\\k<([^!=].*?)>", 32);
    private static final java.util.regex.Pattern PROPERTY_PATTERN = java.util.regex.Pattern.compile("\\$\\{([^!=].*?)\\}", 32);
    private static final int INDEX_GROUP_NAME = 1;
    public static final int UNIX_LINES = 1;
    public static final int CASE_INSENSITIVE = 2;
    public static final int COMMENTS = 4;
    public static final int MULTILINE = 8;
    public static final int LITERAL = 16;
    public static final int DOTALL = 32;
    public static final int UNICODE_CASE = 64;
    public static final int CANON_EQ = 128;
    private java.util.regex.Pattern pattern;
    private String namedPattern;
    private List<String> groupNames;
    private Map<String, List<GroupInfo>> groupInfo;

    protected Pattern(String regex, int flags) {
        this.namedPattern = regex;
        this.groupInfo = Pattern.extractGroupInfo(regex);
        this.pattern = this.buildStandardPattern(regex, flags);
    }

    public static Pattern compile(String regex) {
        return new Pattern(regex, 0);
    }

    public static Pattern compile(String regex, int flags) {
        return new Pattern(regex, flags);
    }

    public int indexOf(String groupName) {
        return this.indexOf(groupName, 0);
    }

    public int indexOf(String groupName, int index) {
        int idx = -1;
        if (this.groupInfo.containsKey(groupName)) {
            List<GroupInfo> list = this.groupInfo.get(groupName);
            idx = list.get(index).groupIndex();
        }
        return idx;
    }

    public int flags() {
        return this.pattern.flags();
    }

    public Matcher matcher(CharSequence input) {
        return new Matcher(this, input);
    }

    public java.util.regex.Pattern pattern() {
        return this.pattern;
    }

    public String standardPattern() {
        return this.pattern.pattern();
    }

    public String namedPattern() {
        return this.namedPattern;
    }

    public List<String> groupNames() {
        if (this.groupNames == null) {
            this.groupNames = new ArrayList<String>(this.groupInfo.keySet());
        }
        return Collections.unmodifiableList(this.groupNames);
    }

    public Map<String, List<GroupInfo>> groupInfo() {
        return Collections.unmodifiableMap(this.groupInfo);
    }

    public String replaceProperties(String replacementPattern) {
        return this.replaceGroupNameWithIndex(new StringBuilder(replacementPattern), PROPERTY_PATTERN, "$").toString();
    }

    public String[] split(CharSequence input, int limit) {
        return this.pattern.split(input, limit);
    }

    public String[] split(CharSequence input) {
        return this.pattern.split(input);
    }

    public String toString() {
        return this.namedPattern;
    }

    private static boolean isEscapedChar(String s, int pos) {
        return Pattern.isSlashEscapedChar(s, pos) || Pattern.isQuoteEscapedChar(s, pos);
    }

    private static boolean isSlashEscapedChar(String s, int pos) {
        int numSlashes = 0;
        while (pos > 0 && s.charAt(pos - 1) == '\\') {
            --pos;
            ++numSlashes;
        }
        return numSlashes % 2 != 0;
    }

    private static boolean isQuoteEscapedChar(String s, int pos) {
        boolean openQuoteFound = false;
        boolean closeQuoteFound = false;
        String s2 = s.substring(0, pos);
        int posOpen = pos;
        while ((posOpen = s2.lastIndexOf("\\Q", posOpen - 1)) != -1) {
            if (Pattern.isSlashEscapedChar(s2, posOpen)) continue;
            openQuoteFound = true;
            break;
        }
        if (openQuoteFound && s2.indexOf("\\E", posOpen) != -1) {
            closeQuoteFound = true;
        }
        return openQuoteFound && !closeQuoteFound;
    }

    private static boolean isInsideCharClass(String s, int pos) {
        boolean openBracketFound = false;
        boolean closeBracketFound = false;
        String s2 = s.substring(0, pos);
        int posOpen = pos;
        while ((posOpen = s2.lastIndexOf(91, posOpen - 1)) != -1) {
            if (Pattern.isEscapedChar(s2, posOpen)) continue;
            openBracketFound = true;
            break;
        }
        if (openBracketFound) {
            String s3 = s.substring(posOpen, pos);
            int posClose = -1;
            while ((posClose = s3.indexOf(93, posClose + 1)) != -1) {
                if (Pattern.isEscapedChar(s3, posClose)) continue;
                closeBracketFound = true;
                break;
            }
        }
        return openBracketFound && !closeBracketFound;
    }

    private static boolean isNoncapturingParen(String s, int pos) {
        boolean isLookbehind = false;
        String pre = s.substring(pos, pos + 4);
        isLookbehind = pre.equals("(?<=") || pre.equals("(?<!");
        return s.charAt(pos + 1) == '?' && (isLookbehind || s.charAt(pos + 2) != '<');
    }

    private static int countOpenParens(String s, int pos) {
        java.util.regex.Pattern p = java.util.regex.Pattern.compile("\\(");
        java.util.regex.Matcher m = p.matcher(s.subSequence(0, pos));
        int numParens = 0;
        while (m.find()) {
            if (Pattern.isInsideCharClass(s, m.start()) || Pattern.isEscapedChar(s, m.start()) || Pattern.isNoncapturingParen(s, m.start())) continue;
            ++numParens;
        }
        return numParens;
    }

    public static Map<String, List<GroupInfo>> extractGroupInfo(String namedPattern) {
        LinkedHashMap<String, List<GroupInfo>> groupInfo = new LinkedHashMap<String, List<GroupInfo>>();
        java.util.regex.Matcher matcher = NAMED_GROUP_PATTERN.matcher(namedPattern);
        while (matcher.find()) {
            int pos = matcher.start();
            if (Pattern.isEscapedChar(namedPattern, pos)) continue;
            String name = matcher.group(1);
            int groupIndex = Pattern.countOpenParens(namedPattern, pos);
            List list = groupInfo.containsKey(name) ? (List)groupInfo.get(name) : new ArrayList();
            list.add(new GroupInfo(groupIndex, pos));
            groupInfo.put(name, list);
        }
        return groupInfo;
    }

    private static StringBuilder replace(StringBuilder input, java.util.regex.Pattern pattern, String replacement) {
        java.util.regex.Matcher m = pattern.matcher(input);
        while (m.find()) {
            if (Pattern.isEscapedChar(input.toString(), m.start())) continue;
            input.replace(m.start(), m.end(), replacement);
            m.reset(input);
        }
        return input;
    }

    private StringBuilder replaceGroupNameWithIndex(StringBuilder input, java.util.regex.Pattern pattern, String prefix) {
        java.util.regex.Matcher m = pattern.matcher(input);
        while (m.find()) {
            if (Pattern.isEscapedChar(input.toString(), m.start())) continue;
            int index = this.indexOf(m.group(1));
            if (index < 0) {
                throw new PatternSyntaxException("unknown group name", input.toString(), m.start(1));
            }
            input.replace(m.start(), m.end(), prefix + ++index);
            m.reset(input);
        }
        return input;
    }

    private java.util.regex.Pattern buildStandardPattern(String namedPattern, Integer flags) {
        StringBuilder s = new StringBuilder(namedPattern);
        s = Pattern.replace(s, NAMED_GROUP_PATTERN, "(");
        s = this.replaceGroupNameWithIndex(s, BACKREF_NAMED_GROUP_PATTERN, "\\");
        return java.util.regex.Pattern.compile(s.toString(), flags);
    }

    private boolean groupInfoMatches(Map<String, List<GroupInfo>> a, Map<String, List<GroupInfo>> b) {
        if (a == null && b == null) {
            return true;
        }
        boolean isMatch = false;
        if (a != null && b != null) {
            if (a.isEmpty() && b.isEmpty()) {
                isMatch = true;
            } else if (a.size() == b.size()) {
                for (Map.Entry<String, List<GroupInfo>> entry : a.entrySet()) {
                    List<GroupInfo> thisList;
                    List<GroupInfo> otherList = b.get(entry.getKey());
                    boolean bl = isMatch = otherList != null;
                    if (isMatch && (isMatch = otherList.containsAll(thisList = entry.getValue()) && thisList.containsAll(otherList))) continue;
                    break;
                }
            }
        }
        return isMatch;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Pattern)) {
            return false;
        }
        Pattern other = (Pattern)obj;
        boolean groupNamesMatch = this.groupNames == null && other.groupNames == null || this.groupNames != null && !Collections.disjoint(this.groupNames, other.groupNames);
        boolean groupInfoMatch = groupNamesMatch && this.groupInfoMatches(this.groupInfo, other.groupInfo);
        return groupNamesMatch && groupInfoMatch && this.namedPattern.equals(other.namedPattern) && this.pattern.flags() == other.pattern.flags();
    }

    public int hashCode() {
        int hash = this.namedPattern.hashCode() ^ this.pattern.hashCode();
        if (this.groupInfo != null) {
            hash ^= this.groupInfo.hashCode();
        }
        if (this.groupNames != null) {
            hash ^= this.groupNames.hashCode();
        }
        return hash;
    }
}

