/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.acl;

import com.jamesmurty.utils.XMLBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.jets3t.service.ServiceException;
import org.jets3t.service.acl.GrantAndPermission;
import org.jets3t.service.acl.GranteeInterface;
import org.jets3t.service.acl.Permission;
import org.jets3t.service.model.StorageOwner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessControlList
implements Serializable {
    private static final long serialVersionUID = -4616688515622838285L;
    public static final AccessControlList REST_CANNED_PRIVATE = new AccessControlList();
    public static final AccessControlList REST_CANNED_PUBLIC_READ = new AccessControlList();
    public static final AccessControlList REST_CANNED_PUBLIC_READ_WRITE = new AccessControlList();
    public static final AccessControlList REST_CANNED_AUTHENTICATED_READ = new AccessControlList();
    protected final HashSet<GrantAndPermission> grants = new HashSet();
    protected StorageOwner owner = null;

    public String toString() {
        return "AccessControlList [owner=" + this.owner + ", grants=" + Arrays.toString(this.getGrantAndPermissions()) + "]";
    }

    public StorageOwner getOwner() {
        return this.owner;
    }

    public void setOwner(StorageOwner owner) {
        this.owner = owner;
    }

    public List<Permission> getPermissionsForGrantee(GranteeInterface grantee) {
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        for (GrantAndPermission gap : this.grants) {
            if (!gap.getGrantee().equals(grantee)) continue;
            permissions.add(gap.getPermission());
        }
        return permissions;
    }

    public List<GranteeInterface> getGranteesWithPermission(Permission permission) {
        ArrayList<GranteeInterface> grantees = new ArrayList<GranteeInterface>();
        for (GrantAndPermission gap : this.grants) {
            if (!gap.getPermission().equals(permission)) continue;
            grantees.add(gap.getGrantee());
        }
        return grantees;
    }

    public boolean hasGranteeAndPermission(GranteeInterface grantee, Permission permission) {
        return this.getPermissionsForGrantee(grantee).contains(permission);
    }

    public void grantPermission(GranteeInterface grantee, Permission permission) {
        this.grants.add(new GrantAndPermission(grantee, permission));
    }

    public void grantAllPermissions(GrantAndPermission[] grantAndPermissions) {
        for (GrantAndPermission gap : grantAndPermissions) {
            this.grantPermission(gap.getGrantee(), gap.getPermission());
        }
    }

    public void revokeAllPermissions(GranteeInterface grantee) {
        ArrayList<GrantAndPermission> grantsToRemove = new ArrayList<GrantAndPermission>();
        for (GrantAndPermission gap : this.grants) {
            if (!gap.getGrantee().equals(grantee)) continue;
            grantsToRemove.add(gap);
        }
        this.grants.removeAll(grantsToRemove);
    }

    public GrantAndPermission[] getGrantAndPermissions() {
        return this.grants.toArray(new GrantAndPermission[this.grants.size()]);
    }

    public XMLBuilder toXMLBuilder() throws ServiceException, ParserConfigurationException, FactoryConfigurationError, TransformerException {
        if (this.owner == null) {
            throw new ServiceException("Invalid AccessControlList: missing an owner");
        }
        if (this.owner.getId() == null || "".equals(this.owner.getId())) {
            throw new ServiceException("Invalid AccessControlList: missing owner ID");
        }
        String ownerDisplayName = this.owner.getDisplayName() == null ? "" : this.owner.getDisplayName();
        XMLBuilder builder = XMLBuilder.create((String)"AccessControlPolicy").attr("xmlns", "http://s3.amazonaws.com/doc/2006-03-01/").elem("Owner").elem("ID").text(this.owner.getId()).up().elem("DisplayName").text(ownerDisplayName).up().up();
        XMLBuilder accessControlList = builder.elem("AccessControlList");
        for (GrantAndPermission gap : this.grants) {
            GranteeInterface grantee = gap.getGrantee();
            Permission permission = gap.getPermission();
            accessControlList.elem("Grant").importXMLBuilder(grantee.toXMLBuilder()).elem("Permission").text(permission.toString());
        }
        return builder;
    }

    public String toXml() throws ServiceException {
        try {
            return this.toXMLBuilder().asString();
        }
        catch (Exception e) {
            throw new ServiceException("Failed to build XML document for ACL", e);
        }
    }

    @Deprecated
    public boolean isCannedRestACL() {
        return this.isRESTHeaderACL();
    }

    public boolean isRESTHeaderACL() {
        return this.getValueForRESTHeaderACL() != null;
    }

    public String getValueForRESTHeaderACL() {
        if (REST_CANNED_PRIVATE.equals(this)) {
            return "private";
        }
        if (REST_CANNED_PUBLIC_READ.equals(this)) {
            return "public-read";
        }
        if (REST_CANNED_PUBLIC_READ_WRITE.equals(this)) {
            return "public-read-write";
        }
        if (REST_CANNED_AUTHENTICATED_READ.equals(this)) {
            return "authenticated-read";
        }
        return null;
    }
}

