/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.tasks;

import java.io.IOException;
import java.nio.charset.Charset;
import net.lingala.zip4j.io.inputstream.SplitInputStream;
import net.lingala.zip4j.io.inputstream.ZipInputStream;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.tasks.AbstractExtractFileTask;
import net.lingala.zip4j.tasks.AbstractZipTaskParameters;
import net.lingala.zip4j.tasks.AsyncZipTask;
import net.lingala.zip4j.util.UnzipUtil;

public class ExtractAllFilesTask
extends AbstractExtractFileTask<ExtractAllFilesTaskParameters> {
    private char[] password;
    private SplitInputStream splitInputStream;

    public ExtractAllFilesTask(ZipModel zipModel, char[] password, AsyncZipTask.AsyncTaskParameters asyncTaskParameters) {
        super(zipModel, asyncTaskParameters);
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeTask(ExtractAllFilesTaskParameters taskParameters, ProgressMonitor progressMonitor) throws IOException {
        try (ZipInputStream zipInputStream = this.prepareZipInputStream(taskParameters.charset);){
            for (FileHeader fileHeader : this.getZipModel().getCentralDirectory().getFileHeaders()) {
                if (fileHeader.getFileName().startsWith("__MACOSX")) {
                    progressMonitor.updateWorkCompleted(fileHeader.getUncompressedSize());
                    continue;
                }
                this.splitInputStream.prepareExtractionForFileHeader(fileHeader);
                this.extractFile(zipInputStream, fileHeader, taskParameters.outputPath, null, progressMonitor);
                this.verifyIfTaskIsCancelled();
            }
        }
        finally {
            if (this.splitInputStream != null) {
                this.splitInputStream.close();
            }
        }
    }

    @Override
    protected long calculateTotalWork(ExtractAllFilesTaskParameters taskParameters) {
        long totalWork = 0L;
        for (FileHeader fileHeader : this.getZipModel().getCentralDirectory().getFileHeaders()) {
            if (fileHeader.getZip64ExtendedInfo() != null && fileHeader.getZip64ExtendedInfo().getUncompressedSize() > 0L) {
                totalWork += fileHeader.getZip64ExtendedInfo().getUncompressedSize();
                continue;
            }
            totalWork += fileHeader.getUncompressedSize();
        }
        return totalWork;
    }

    private ZipInputStream prepareZipInputStream(Charset charset) throws IOException {
        this.splitInputStream = UnzipUtil.createSplitInputStream(this.getZipModel());
        FileHeader fileHeader = this.getFirstFileHeader(this.getZipModel());
        if (fileHeader != null) {
            this.splitInputStream.prepareExtractionForFileHeader(fileHeader);
        }
        return new ZipInputStream(this.splitInputStream, this.password, charset);
    }

    private FileHeader getFirstFileHeader(ZipModel zipModel) {
        if (zipModel.getCentralDirectory() == null || zipModel.getCentralDirectory().getFileHeaders() == null || zipModel.getCentralDirectory().getFileHeaders().size() == 0) {
            return null;
        }
        return zipModel.getCentralDirectory().getFileHeaders().get(0);
    }

    public static class ExtractAllFilesTaskParameters
    extends AbstractZipTaskParameters {
        private String outputPath;

        public ExtractAllFilesTaskParameters(String outputPath, Charset charset) {
            super(charset);
            this.outputPath = outputPath;
        }
    }
}

