/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.nonstop.store;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import net.sf.ehcache.config.TimeoutBehaviorConfiguration;
import net.sf.ehcache.constructs.nonstop.ClusterOperation;
import net.sf.ehcache.constructs.nonstop.store.ExecutorServiceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RejoinAwareBlockingOperation<V>
implements Callable<V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RejoinAwareBlockingOperation.class);
    private static final long REJOIN_RETRY_INTERVAL = 10000L;
    private final Callable<V> delegateCallable;
    private final ExecutorServiceStore executorServiceStore;
    private volatile Thread executingThread;
    private volatile boolean rejoinHappened;

    public RejoinAwareBlockingOperation(ExecutorServiceStore executorServiceStore, Callable<V> callable) {
        this.executorServiceStore = executorServiceStore;
        this.delegateCallable = callable;
    }

    @Override
    public V call() throws Exception {
        this.executingThread = Thread.currentThread();
        return this.executeUntilComplete();
    }

    private V executeUntilComplete() throws Exception {
        while (true) {
            try {
                while (true) {
                    this.rejoinHappened = false;
                    try {
                        this.executorServiceStore.executeClusterOperationNoTimeout(new ClusterOperation<V>(){

                            @Override
                            public V performClusterOperation() throws Exception {
                                return RejoinAwareBlockingOperation.this.delegateCallable.call();
                            }

                            @Override
                            public V performClusterOperationTimedOut(TimeoutBehaviorConfiguration.TimeoutBehaviorType configuredTimeoutBehavior) {
                                throw new AssertionError((Object)"This should never happen as executed with no-timeout");
                            }
                        });
                        return this.delegateCallable.call();
                    }
                    catch (TimeoutException e) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Timed out. Assuming the cluster is down and trying again later.");
                        }
                        Thread.sleep(10000L);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                if (this.rejoinHappened) {
                    LOGGER.debug("Caught InterruptedException caused by rejoin. Executing callable again.");
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public void clusterRejoined() {
        this.rejoinHappened = true;
        if (this.executingThread != null) {
            LOGGER.debug("Interrupting executing thread (id=" + this.executingThread.getId() + ", name='" + this.executingThread.getName() + "') as rejoin happened");
            this.executingThread.interrupt();
        }
    }
}

