/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.sort.actions;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.web.commands.Command;

public class RemoveSortFieldCommand
implements Command {
    private JRDesignDataset dataset;
    private JRSortField sortField;
    private int removeIndex;

    public RemoveSortFieldCommand(JRDesignDataset dataset, JRSortField sortField) {
        this.dataset = dataset;
        this.sortField = sortField;
    }

    @Override
    public void execute() {
        this.removeIndex = this.dataset.getSortFieldsList().indexOf(this.sortField);
        if (this.removeIndex >= 0) {
            this.dataset.removeSortField(this.sortField);
        }
    }

    @Override
    public void undo() {
        if (this.removeIndex >= 0) {
            try {
                this.dataset.addSortField(this.removeIndex, this.sortField);
            }
            catch (JRException e) {
                throw new JRRuntimeException(e);
            }
        }
    }

    @Override
    public void redo() {
        this.execute();
    }
}

