/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseElementGroup;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRBoxUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public class JRDesignFrame
extends JRDesignElement
implements JRFrame {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_CHILDREN = "children";
    private List<JRChild> children = new ArrayList<JRChild>();
    private JRLineBox lineBox = new JRBaseLineBox(this);
    private Byte border;
    private Byte topBorder;
    private Byte leftBorder;
    private Byte bottomBorder;
    private Byte rightBorder;
    private Color borderColor;
    private Color topBorderColor;
    private Color leftBorderColor;
    private Color bottomBorderColor;
    private Color rightBorderColor;
    private Integer padding;
    private Integer topPadding;
    private Integer leftPadding;
    private Integer bottomPadding;
    private Integer rightPadding;

    public JRDesignFrame(JRDefaultStyleProvider defaultStyleProvider) {
        super(defaultStyleProvider);
    }

    public JRDesignFrame() {
        this(null);
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitFrame(this);
    }

    @Override
    public JRElement[] getElements() {
        return JRBaseElementGroup.getElements(this.children);
    }

    public void addElement(JRElement element) {
        this.addElement(this.children.size(), element);
    }

    public void addElement(int index, JRElement element) {
        if (element instanceof JRDesignElement) {
            ((JRDesignElement)element).setElementGroup(this);
        }
        this.children.add(index, element);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_CHILDREN, element, index);
    }

    public boolean removeElement(JRElement element) {
        int idx;
        if (element instanceof JRDesignElement) {
            ((JRDesignElement)element).setElementGroup(null);
        }
        if ((idx = this.children.indexOf(element)) >= 0) {
            this.children.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_CHILDREN, element, idx);
            return true;
        }
        return false;
    }

    public void addElementGroup(JRElementGroup group) {
        this.addElementGroup(this.children.size(), group);
    }

    public void addElementGroup(int index, JRElementGroup group) {
        if (group instanceof JRDesignElementGroup) {
            ((JRDesignElementGroup)group).setElementGroup(this);
        }
        this.children.add(index, group);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_CHILDREN, group, index);
    }

    public boolean removeElementGroup(JRElementGroup group) {
        int idx;
        if (group instanceof JRDesignElementGroup) {
            ((JRDesignElementGroup)group).setElementGroup(null);
        }
        if ((idx = this.children.indexOf(group)) >= 0) {
            this.children.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_CHILDREN, group, idx);
            return true;
        }
        return false;
    }

    @Override
    public List<JRChild> getChildren() {
        return this.children;
    }

    @Override
    public JRElement getElementByKey(String elementKey) {
        return JRBaseElementGroup.getElementByKey(this.getElements(), elementKey);
    }

    @Override
    public ModeEnum getModeValue() {
        return JRStyleResolver.getMode(this, ModeEnum.TRANSPARENT);
    }

    @Override
    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    public void copyBox(JRLineBox lineBox) {
        this.lineBox = lineBox.clone(this);
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    @Override
    public Object clone() {
        JRDesignFrame clone = (JRDesignFrame)super.clone();
        if (this.children != null) {
            clone.children = new ArrayList<JRChild>(this.children.size());
            for (int i = 0; i < this.children.size(); ++i) {
                clone.children.add((JRChild)this.children.get(i).clone(clone));
            }
        }
        clone.lineBox = this.lineBox.clone(clone);
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.lineBox == null) {
            this.lineBox = new JRBaseLineBox(this);
            JRBoxUtil.setToBox(this.border, this.topBorder, this.leftBorder, this.bottomBorder, this.rightBorder, this.borderColor, this.topBorderColor, this.leftBorderColor, this.bottomBorderColor, this.rightBorderColor, this.padding, this.topPadding, this.leftPadding, this.bottomPadding, this.rightPadding, this.lineBox);
            this.border = null;
            this.topBorder = null;
            this.leftBorder = null;
            this.bottomBorder = null;
            this.rightBorder = null;
            this.borderColor = null;
            this.topBorderColor = null;
            this.leftBorderColor = null;
            this.bottomBorderColor = null;
            this.rightBorderColor = null;
            this.padding = null;
            this.topPadding = null;
            this.leftPadding = null;
            this.bottomPadding = null;
            this.rightPadding = null;
        }
    }
}

