/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.servlets;

import net.sf.jasperreports.data.cache.ColumnDataCacheHandler;
import net.sf.jasperreports.data.cache.DataCacheHandler;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fill.AsynchronousFillHandle;
import net.sf.jasperreports.repo.RepositoryUtil;
import net.sf.jasperreports.web.JRInteractiveException;
import net.sf.jasperreports.web.WebReportContext;
import net.sf.jasperreports.web.actions.Action;
import net.sf.jasperreports.web.commands.CommandStack;
import net.sf.jasperreports.web.servlets.AsyncJasperPrintAccessor;
import net.sf.jasperreports.web.servlets.JasperPrintAccessor;
import net.sf.jasperreports.web.servlets.SimpleJasperPrintAccessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Controller {
    private static final Log log = LogFactory.getLog(Controller.class);
    private JasperReportsContext jasperReportsContext;

    public Controller(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    public void runReport(WebReportContext webReportContext, Action action) throws JRException, JRInteractiveException {
        JRPropertiesUtil propUtil = JRPropertiesUtil.getInstance(this.jasperReportsContext);
        String reportUriParamName = propUtil.getProperty("net.sf.jasperreports.web.request.parameter.report.uri");
        String reportUri = (String)webReportContext.getParameterValue(reportUriParamName);
        int initialStackSize = 0;
        CommandStack commandStack = (CommandStack)webReportContext.getParameterValue("net.sf.jasperreports.command.stack");
        if (commandStack != null) {
            initialStackSize = commandStack.getExecutionStackSize();
        }
        this.setDataCache(webReportContext);
        JasperReport jasperReport = null;
        if (reportUri != null && reportUri.trim().length() > 0) {
            reportUri = reportUri.trim();
            if (action != null) {
                action.run();
            }
            jasperReport = RepositoryUtil.getInstance(this.jasperReportsContext).getReport(webReportContext, reportUri);
        }
        if (jasperReport == null) {
            throw new JRException("Report not found at : " + reportUri);
        }
        String asyncParamName = propUtil.getProperty("net.sf.jasperreports.web.request.parameter.async.report");
        Boolean async = (Boolean)webReportContext.getParameterValue(asyncParamName);
        if (async == null) {
            async = Boolean.FALSE;
        }
        webReportContext.setParameterValue(asyncParamName, async);
        try {
            this.runReport(webReportContext, jasperReport, async);
        }
        catch (JRException e) {
            this.undoAction(webReportContext, initialStackSize);
            throw e;
        }
        catch (JRRuntimeException e) {
            this.undoAction(webReportContext, initialStackSize);
            throw e;
        }
    }

    private void undoAction(WebReportContext webReportContext, int initialStackSize) {
        CommandStack commandStack = (CommandStack)webReportContext.getParameterValue("net.sf.jasperreports.command.stack");
        if (commandStack != null) {
            for (int i = 0; i < commandStack.getExecutionStackSize() - initialStackSize; ++i) {
                commandStack.undo();
            }
        }
    }

    protected void setDataCache(WebReportContext webReportContext) {
        DataCacheHandler dataCacheHandler = (DataCacheHandler)webReportContext.getParameterValue("net.sf.jasperreports.data.cache.handler");
        if (dataCacheHandler != null && !dataCacheHandler.isSnapshotPopulated()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Data cache handler not final " + dataCacheHandler));
            }
            dataCacheHandler = null;
        }
        if (dataCacheHandler == null) {
            dataCacheHandler = new ColumnDataCacheHandler();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created data cache handler " + dataCacheHandler));
            }
            webReportContext.setParameterValue("net.sf.jasperreports.data.cache.handler", dataCacheHandler);
        }
    }

    protected void runReport(WebReportContext webReportContext, JasperReport jasperReport, boolean async) throws JRException {
        JasperPrintAccessor accessor;
        if (async) {
            AsynchronousFillHandle fillHandle = AsynchronousFillHandle.createHandle(this.jasperReportsContext, jasperReport, webReportContext.getParameterValues());
            AsyncJasperPrintAccessor asyncAccessor = new AsyncJasperPrintAccessor(fillHandle);
            fillHandle.startFill();
            accessor = asyncAccessor;
        } else {
            JasperPrint jasperPrint = JasperFillManager.getInstance(this.jasperReportsContext).fill(jasperReport, webReportContext.getParameterValues());
            accessor = new SimpleJasperPrintAccessor(jasperPrint);
        }
        webReportContext.setParameterValue("net.sf.jasperreports.web.jasper_print.accessor", accessor);
    }
}

