/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.metrics;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.metrics.IntegerValuedMetric;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class HiddenGCICount
extends IntegerValuedMetric {
    public HiddenGCICount(@Nonnull OWLOntology o) {
        super(o);
    }

    @Override
    protected void disposeMetric() {
    }

    @Override
    protected boolean isMetricInvalidated(@Nonnull List<? extends OWLOntologyChange> changes) {
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if ((!oWLOntologyChange.isAxiomChange() || !(oWLOntologyChange.getAxiom() instanceof OWLEquivalentClassesAxiom)) && !(oWLOntologyChange.getAxiom() instanceof OWLSubClassOfAxiom)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Integer recomputeMetric() {
        HashSet<OWLClass> processed = new HashSet<OWLClass>();
        HashSet<OWLClass> result = new HashSet<OWLClass>();
        for (OWLOntology ont : this.getOntologies()) {
            block1: for (OWLClass cls : ont.getClassesInSignature()) {
                assert (cls != null);
                if (processed.contains(cls)) continue;
                processed.add(cls);
                boolean foundEquivalentClassesAxiom = false;
                boolean foundSubClassAxiom = false;
                for (OWLOntology o : this.getOntologies()) {
                    if (!foundEquivalentClassesAxiom) {
                        boolean bl = foundEquivalentClassesAxiom = !o.getEquivalentClassesAxioms(cls).isEmpty();
                    }
                    if (!foundSubClassAxiom) {
                        boolean bl = foundSubClassAxiom = !o.getSubClassAxiomsForSubClass(cls).isEmpty();
                    }
                    if (!foundSubClassAxiom || !foundEquivalentClassesAxiom) continue;
                    result.add(cls);
                    continue block1;
                }
            }
        }
        return result.size();
    }

    @Override
    public String getName() {
        return "Hidden GCI Count";
    }
}

