/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.profiles;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.profiles.OWL2DLProfile;
import org.semanticweb.owlapi.profiles.OWLOntologyProfileWalker;
import org.semanticweb.owlapi.profiles.OWLProfile;
import org.semanticweb.owlapi.profiles.OWLProfileReport;
import org.semanticweb.owlapi.profiles.OWLProfileViolation;
import org.semanticweb.owlapi.profiles.Profiles;
import org.semanticweb.owlapi.profiles.violations.UseOfAnonymousIndividual;
import org.semanticweb.owlapi.profiles.violations.UseOfIllegalAxiom;
import org.semanticweb.owlapi.profiles.violations.UseOfIllegalDataRange;
import org.semanticweb.owlapi.profiles.violations.UseOfNonAtomicClassExpression;
import org.semanticweb.owlapi.profiles.violations.UseOfNonSubClassExpression;
import org.semanticweb.owlapi.profiles.violations.UseOfNonSuperClassExpression;
import org.semanticweb.owlapi.util.OWLClassExpressionVisitorExAdapter;
import org.semanticweb.owlapi.util.OWLOntologyWalker;
import org.semanticweb.owlapi.util.OWLOntologyWalkerVisitor;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

public class OWL2QLProfile
implements OWLProfile {
    protected static final Set<IRI> ALLOWED_DATATYPES = new HashSet<IRI>(Arrays.asList(OWL2Datatype.RDF_PLAIN_LITERAL.getIRI(), OWL2Datatype.RDF_XML_LITERAL.getIRI(), OWL2Datatype.RDFS_LITERAL.getIRI(), OWL2Datatype.OWL_REAL.getIRI(), OWL2Datatype.OWL_RATIONAL.getIRI(), OWL2Datatype.XSD_DECIMAL.getIRI(), OWL2Datatype.XSD_INTEGER.getIRI(), OWL2Datatype.XSD_NON_NEGATIVE_INTEGER.getIRI(), OWL2Datatype.XSD_STRING.getIRI(), OWL2Datatype.XSD_NORMALIZED_STRING.getIRI(), OWL2Datatype.XSD_TOKEN.getIRI(), OWL2Datatype.XSD_NAME.getIRI(), OWL2Datatype.XSD_NCNAME.getIRI(), OWL2Datatype.XSD_NMTOKEN.getIRI(), OWL2Datatype.XSD_HEX_BINARY.getIRI(), OWL2Datatype.XSD_BASE_64_BINARY.getIRI(), OWL2Datatype.XSD_ANY_URI.getIRI(), OWL2Datatype.XSD_DATE_TIME.getIRI(), OWL2Datatype.XSD_DATE_TIME_STAMP.getIRI()));
    @Nonnull
    private final OWL2QLSubClassExpressionChecker subClassExpressionChecker = new OWL2QLSubClassExpressionChecker();
    @Nonnull
    private final OWL2QLSuperClassExpressionChecker superClassExpressionChecker = new OWL2QLSuperClassExpressionChecker();

    @Nonnull
    static Boolean b(boolean b) {
        return b;
    }

    @Override
    public String getName() {
        return "OWL 2 QL";
    }

    @Override
    @Nonnull
    public IRI getIRI() {
        return Profiles.OWL2_QL.getIRI();
    }

    @Override
    public OWLProfileReport checkOntology(OWLOntology ontology) {
        OWL2DLProfile profile = new OWL2DLProfile();
        OWLProfileReport report = profile.checkOntology(ontology);
        HashSet<OWLProfileViolation> violations = new HashSet<OWLProfileViolation>();
        violations.addAll(report.getViolations());
        OWLOntologyProfileWalker walker = new OWLOntologyProfileWalker(ontology.getImportsClosure());
        OWL2QLObjectVisitor visitor = new OWL2QLObjectVisitor(walker);
        walker.walkStructure(visitor);
        violations.addAll(visitor.getProfileViolations());
        return new OWLProfileReport(this, violations);
    }

    protected boolean isOWL2QLSubClassExpression(OWLClassExpression ce) {
        return ce.accept(this.subClassExpressionChecker);
    }

    public boolean isOWL2QLSuperClassExpression(OWLClassExpression ce) {
        return ce.accept(this.superClassExpressionChecker);
    }

    private class OWL2QLSuperClassExpressionChecker
    extends OWLClassExpressionVisitorExAdapter<Boolean> {
        OWL2QLSuperClassExpressionChecker() {
            super(OWL2QLProfile.b(false));
        }

        @Override
        public Boolean visit(OWLClass ce) {
            return OWL2QLProfile.b(true);
        }

        @Override
        public Boolean visit(OWLObjectIntersectionOf ce) {
            for (OWLClassExpression e : ce.getOperands()) {
                if (e.accept(this).booleanValue()) continue;
                return OWL2QLProfile.b(false);
            }
            return OWL2QLProfile.b(true);
        }

        @Override
        public Boolean visit(OWLObjectComplementOf ce) {
            return OWL2QLProfile.b(OWL2QLProfile.this.isOWL2QLSubClassExpression(ce.getOperand()));
        }

        @Override
        public Boolean visit(OWLObjectSomeValuesFrom ce) {
            return OWL2QLProfile.b(!((OWLClassExpression)ce.getFiller()).isAnonymous());
        }

        @Override
        public Boolean visit(OWLDataSomeValuesFrom ce) {
            return OWL2QLProfile.b(true);
        }
    }

    private static class OWL2QLSubClassExpressionChecker
    extends OWLClassExpressionVisitorExAdapter<Boolean> {
        OWL2QLSubClassExpressionChecker() {
            super(OWL2QLProfile.b(false));
        }

        @Override
        public Boolean visit(OWLClass ce) {
            return OWL2QLProfile.b(true);
        }

        @Override
        public Boolean visit(OWLObjectSomeValuesFrom ce) {
            return OWL2QLProfile.b(((OWLClassExpression)ce.getFiller()).isOWLThing());
        }

        @Override
        public Boolean visit(OWLDataSomeValuesFrom ce) {
            return OWL2QLProfile.b(true);
        }
    }

    private class OWL2QLObjectVisitor
    extends OWLOntologyWalkerVisitor {
        @Nonnull
        private final Set<OWLProfileViolation> violations;

        OWL2QLObjectVisitor(OWLOntologyWalker walker) {
            super(walker);
            this.violations = new HashSet<OWLProfileViolation>();
        }

        public Set<OWLProfileViolation> getProfileViolations() {
            return new HashSet<OWLProfileViolation>(this.violations);
        }

        @Override
        public void visit(OWLDatatype node) {
            if (!ALLOWED_DATATYPES.contains(node.getIRI())) {
                this.violations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), node));
            }
        }

        @Override
        public void visit(OWLAnonymousIndividual individual) {
            this.violations.add(new UseOfAnonymousIndividual(this.getCurrentOntology(), this.getCurrentAxiom(), individual));
        }

        @Override
        public void visit(OWLHasKeyAxiom axiom) {
            this.violations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
        }

        @Override
        public void visit(OWLSubClassOfAxiom axiom) {
            if (!OWL2QLProfile.this.isOWL2QLSubClassExpression(axiom.getSubClass())) {
                this.violations.add(new UseOfNonSubClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, axiom.getSubClass()));
            }
            if (!OWL2QLProfile.this.isOWL2QLSuperClassExpression(axiom.getSuperClass())) {
                this.violations.add(new UseOfNonSuperClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, axiom.getSuperClass()));
            }
        }

        @Override
        public void visit(OWLEquivalentClassesAxiom axiom) {
            for (OWLClassExpression ce : axiom.getClassExpressions()) {
                assert (ce != null);
                if (OWL2QLProfile.this.isOWL2QLSubClassExpression(ce)) continue;
                this.violations.add(new UseOfNonSubClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, ce));
            }
        }

        @Override
        public void visit(OWLDisjointClassesAxiom axiom) {
            this.violations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
        }

        @Override
        public void visit(OWLObjectPropertyDomainAxiom axiom) {
            if (!OWL2QLProfile.this.isOWL2QLSuperClassExpression(axiom.getDomain())) {
                this.violations.add(new UseOfNonSuperClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, axiom.getDomain()));
            }
        }

        @Override
        public void visit(OWLObjectPropertyRangeAxiom axiom) {
            if (!OWL2QLProfile.this.isOWL2QLSuperClassExpression((OWLClassExpression)axiom.getRange())) {
                this.violations.add(new UseOfNonSuperClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, (OWLClassExpression)axiom.getRange()));
            }
        }

        @Override
        public void visit(OWLSubPropertyChainOfAxiom axiom) {
            this.violations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
        }

        @Override
        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
            this.violations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
        }

        @Override
        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            this.violations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
        }

        @Override
        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
            this.violations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
        }

        @Override
        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
            this.violations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
        }

        @Override
        public void visit(OWLDataPropertyDomainAxiom axiom) {
            if (!OWL2QLProfile.this.isOWL2QLSuperClassExpression(axiom.getDomain())) {
                this.violations.add(new UseOfNonSuperClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, axiom.getDomain()));
            }
        }

        @Override
        public void visit(OWLClassAssertionAxiom axiom) {
            if (axiom.getClassExpression().isAnonymous()) {
                this.violations.add(new UseOfNonAtomicClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, axiom.getClassExpression()));
            }
        }

        @Override
        public void visit(OWLSameIndividualAxiom axiom) {
            this.violations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
        }

        @Override
        public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            this.violations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
        }

        @Override
        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            this.violations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
        }

        @Override
        public void visit(OWLDisjointUnionAxiom axiom) {
            this.violations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
        }

        @Override
        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            this.violations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
        }

        @Override
        public void visit(SWRLRule rule) {
            this.violations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), rule));
        }

        @Override
        public void visit(OWLDataComplementOf node) {
            this.violations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), node));
        }

        @Override
        public void visit(OWLDataOneOf node) {
            this.violations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), node));
        }

        @Override
        public void visit(OWLDatatypeRestriction node) {
            this.violations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), node));
        }

        @Override
        public void visit(OWLDataUnionOf node) {
            this.violations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), node));
        }
    }
}

