/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.profiles;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.profiles.OWLProfileViolationVisitor;
import org.semanticweb.owlapi.profiles.OWLProfileViolationVisitorEx;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public abstract class OWLProfileViolation {
    @Nonnull
    protected final OWLOntology ontology;
    @Nonnull
    protected final OWLDataFactory df;
    @Nullable
    protected final OWLAxiom axiom;
    @Nullable
    protected final Object expression;

    public OWLProfileViolation(@Nonnull OWLOntology ontology, @Nullable OWLAxiom axiom, @Nullable Object o) {
        this.axiom = axiom;
        this.ontology = ontology;
        this.df = ontology.getOWLOntologyManager().getOWLDataFactory();
        this.expression = o;
    }

    public OWLOntologyID getOntologyID() {
        return this.ontology.getOntologyID();
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }

    @Nonnull
    public Object getExpression() {
        return OWLAPIPreconditions.verifyNotNull(this.expression);
    }

    @Nonnull
    public OWLAxiom getAxiom() {
        return OWLAPIPreconditions.verifyNotNull(this.axiom);
    }

    @Nonnull
    public List<OWLOntologyChange> repair() {
        if (this.axiom != null) {
            return this.list(new RemoveAxiom(this.ontology, this.getAxiom()));
        }
        return CollectionFactory.emptyList();
    }

    protected AddAxiom addDeclaration(@Nonnull OWLEntity e) {
        return new AddAxiom(this.ontology, this.df.getOWLDeclarationAxiom(e));
    }

    public abstract void accept(@Nonnull OWLProfileViolationVisitor var1);

    @Nonnull
    public abstract <O> O accept(@Nonnull OWLProfileViolationVisitorEx<O> var1);

    @Nonnull
    protected String toString(String template) {
        return String.format(template + " [%s in %s]", this.axiom, this.ontology.getOntologyID());
    }

    @Nonnull
    protected String toString(String template, Object object) {
        return String.format(template + " [%s in %s]", object, this.axiom, this.ontology.getOntologyID());
    }

    @Nonnull
    protected String toString(String template, Object object1, Object object2) {
        return String.format(template + " [%s in %s]", object1, object2, this.axiom, this.ontology.getOntologyID());
    }

    @Nonnull
    protected List<OWLOntologyChange> list(OWLOntologyChange ... changes) {
        return CollectionFactory.list(changes);
    }
}

