/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.rdfxml.renderer;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.io.RDFLiteral;
import org.semanticweb.owlapi.io.RDFNode;
import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.io.RDFResourceBlankNode;
import org.semanticweb.owlapi.io.RDFTriple;
import org.semanticweb.owlapi.io.XMLUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.rdf.RDFRendererBase;
import org.semanticweb.owlapi.rdf.rdfxml.renderer.RDFXMLNamespaceManager;
import org.semanticweb.owlapi.rdf.rdfxml.renderer.RDFXMLWriter;
import org.semanticweb.owlapi.rdf.rdfxml.renderer.XMLWriterFactory;
import org.semanticweb.owlapi.util.AnnotationValueShortFormProvider;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.util.VersionInfo;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class RDFXMLRenderer
extends RDFRendererBase {
    private final RDFXMLWriter writer;
    @Nonnull
    private final Set<RDFResource> pending = new HashSet<RDFResource>();
    @Nonnull
    private final RDFXMLNamespaceManager qnameManager;
    @Nonnull
    private final OWLDocumentFormat format;
    ShortFormProvider labelMaker;

    public RDFXMLRenderer(@Nonnull OWLOntology ontology, @Nonnull Writer w) {
        this(OWLAPIPreconditions.checkNotNull(ontology, "ontology cannot be null"), OWLAPIPreconditions.checkNotNull(w, "w cannot be null"), OWLAPIPreconditions.verifyNotNull(ontology.getOWLOntologyManager().getOntologyFormat(ontology)));
    }

    public RDFXMLRenderer(@Nonnull OWLOntology ontology, @Nonnull Writer w, @Nonnull OWLDocumentFormat format) {
        super(OWLAPIPreconditions.checkNotNull(ontology, "ontology cannot be null"), OWLAPIPreconditions.checkNotNull(format, "format cannot be null"));
        this.format = OWLAPIPreconditions.checkNotNull(format, "format cannot be null");
        this.qnameManager = new RDFXMLNamespaceManager(ontology, format);
        String defaultNamespace = this.qnameManager.getDefaultNamespace();
        String base = RDFXMLRenderer.base(defaultNamespace);
        this.writer = new RDFXMLWriter(XMLWriterFactory.createXMLWriter(OWLAPIPreconditions.checkNotNull(w, "w cannot be null"), this.qnameManager, base));
        HashMap<OWLAnnotationProperty, List<String>> prefLangMap = new HashMap<OWLAnnotationProperty, List<String>>();
        OWLOntologyManager manager = ontology.getOWLOntologyManager();
        OWLDataFactory df = manager.getOWLDataFactory();
        OWLAnnotationProperty labelProp = df.getOWLAnnotationProperty(OWLRDFVocabulary.RDFS_LABEL.getIRI());
        this.labelMaker = new AnnotationValueShortFormProvider(Collections.singletonList(labelProp), prefLangMap, manager);
    }

    @Nonnull
    private static String base(@Nonnull String defaultNamespace) {
        String base = defaultNamespace.endsWith("#") ? defaultNamespace.substring(0, defaultNamespace.length() - 1) : defaultNamespace;
        return base;
    }

    @Nonnull
    public Set<OWLEntity> getUnserialisableEntities() {
        return this.qnameManager.getEntitiesWithInvalidQNames();
    }

    @Override
    protected void beginDocument() throws IOException {
        this.writer.startDocument();
    }

    @Override
    protected void endDocument() throws IOException {
        this.writer.endDocument();
        this.writer.writeComment(VersionInfo.getVersionInfo().getGeneratedByMessage());
        if (!this.format.isAddMissingTypes()) {
            this.writer.writeComment("Warning: type declarations were not added automatically.");
        }
    }

    @Override
    protected void writeIndividualComments(@Nonnull OWLNamedIndividual ind) throws IOException {
        this.writeCommentForEntity("ind", ind);
    }

    @Override
    protected void writeClassComment(@Nonnull OWLClass cls) throws IOException {
        this.writeCommentForEntity("cls", cls);
    }

    @Override
    protected void writeDataPropertyComment(@Nonnull OWLDataProperty prop) throws IOException {
        this.writeCommentForEntity("prop", prop);
    }

    @Override
    protected void writeObjectPropertyComment(@Nonnull OWLObjectProperty prop) throws IOException {
        this.writeCommentForEntity("prop", prop);
    }

    @Override
    protected void writeAnnotationPropertyComment(@Nonnull OWLAnnotationProperty prop) throws IOException {
        this.writeCommentForEntity("prop", prop);
    }

    @Override
    protected void writeDatatypeComment(@Nonnull OWLDatatype datatype) throws IOException {
        this.writeCommentForEntity("datatype", datatype);
    }

    private void writeCommentForEntity(String msg, OWLEntity entity) throws IOException {
        OWLAPIPreconditions.checkNotNull(entity, msg + " cannot be null");
        String iriString = entity.getIRI().toString();
        String labelString = this.labelMaker.getShortForm(entity);
        String commentString = null;
        commentString = !iriString.equals(labelString) ? labelString : iriString;
        this.writer.writeComment(XMLUtils.escapeXML(commentString));
    }

    @Override
    protected void writeBanner(@Nonnull String name) throws IOException {
        this.writer.writeComment("\n///////////////////////////////////////////////////////////////////////////////////////\n//\n// " + OWLAPIPreconditions.checkNotNull(name, "name cannot be null") + "\n//\n///////////////////////////////////////////////////////////////////////////////////////\n");
    }

    @Override
    public void render(@Nonnull RDFResource node) throws IOException {
        OWLAPIPreconditions.checkNotNull(node, "node cannot be null");
        if (this.pending.contains(node)) {
            return;
        }
        this.pending.add(node);
        RDFTriple candidatePrettyPrintTypeTriple = null;
        Collection<RDFTriple> triples = this.graph.getTriplesForSubject(node, true);
        for (RDFTriple triple : triples) {
            IRI propertyIRI = triple.getPredicate().getIRI();
            if (!propertyIRI.equals(OWLRDFVocabulary.RDF_TYPE.getIRI()) || triple.getObject().isAnonymous() || !OWLRDFVocabulary.BUILT_IN_VOCABULARY_IRIS.contains(triple.getObject().getIRI()) || !this.prettyPrintedTypes.contains(triple.getObject().getIRI())) continue;
            candidatePrettyPrintTypeTriple = triple;
        }
        if (candidatePrettyPrintTypeTriple == null) {
            this.writer.writeStartElement(OWLRDFVocabulary.RDF_DESCRIPTION.getIRI());
        } else {
            this.writer.writeStartElement(candidatePrettyPrintTypeTriple.getObject().getIRI());
        }
        if (!node.isAnonymous()) {
            this.writer.writeAboutAttribute(node.getIRI());
        }
        for (RDFTriple triple : triples) {
            if (candidatePrettyPrintTypeTriple != null && candidatePrettyPrintTypeTriple.equals(triple)) continue;
            this.writer.writeStartElement(triple.getPredicate().getIRI());
            RDFNode objectNode = triple.getObject();
            if (!objectNode.isLiteral()) {
                RDFResource objectRes = (RDFResource)objectNode;
                if (objectRes.isAnonymous()) {
                    if (this.isObjectList(objectRes)) {
                        this.writer.writeParseTypeAttribute();
                        ArrayList<RDFNode> list = new ArrayList<RDFNode>();
                        this.toJavaList(objectRes, list);
                        for (RDFNode n : list) {
                            if (n.isAnonymous()) {
                                this.render((RDFResourceBlankNode)n);
                                continue;
                            }
                            if (n.isLiteral()) {
                                RDFLiteral litNode = (RDFLiteral)n;
                                this.writer.writeStartElement(OWLRDFVocabulary.RDFS_LITERAL.getIRI());
                                if (!litNode.isPlainLiteral()) {
                                    this.writer.writeDatatypeAttribute(litNode.getDatatype());
                                } else if (litNode.hasLang()) {
                                    this.writer.writeLangAttribute(litNode.getLang());
                                }
                                this.writer.writeTextContent(litNode.getLexicalValue());
                                this.writer.writeEndElement();
                                continue;
                            }
                            this.writer.writeStartElement(OWLRDFVocabulary.RDF_DESCRIPTION.getIRI());
                            this.writer.writeAboutAttribute(n.getIRI());
                            this.writer.writeEndElement();
                        }
                    } else {
                        this.render(objectRes);
                    }
                } else {
                    this.writer.writeResourceAttribute(objectRes.getIRI());
                }
            } else {
                RDFLiteral rdfLiteralNode = (RDFLiteral)objectNode;
                if (!rdfLiteralNode.isPlainLiteral()) {
                    this.writer.writeDatatypeAttribute(rdfLiteralNode.getDatatype());
                } else if (rdfLiteralNode.hasLang()) {
                    this.writer.writeLangAttribute(rdfLiteralNode.getLang());
                }
                this.writer.writeTextContent(rdfLiteralNode.getLexicalValue());
            }
            this.writer.writeEndElement();
        }
        this.writer.writeEndElement();
        this.pending.remove(node);
    }
}

