/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import com.google.common.collect.Iterators;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.MIMETypeAware;
import org.semanticweb.owlapi.model.PriorityCollectionSorting;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class PriorityCollection<T extends Serializable>
implements Iterable<T>,
Serializable {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final List<T> delegate = Collections.synchronizedList(new ArrayList());
    private final PriorityCollectionSorting sorting;

    public PriorityCollection(PriorityCollectionSorting sorting) {
        this.sorting = sorting;
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public int size() {
        return this.delegate.size();
    }

    private void sort() {
        this.sorting.sort(this.delegate);
    }

    private void sortSet() {
        this.sorting.sortInputSet(this.delegate);
    }

    public void set(Iterable<T> c) {
        this.clear();
        this.add(c);
    }

    public void set(Set<T> c) {
        this.clear();
        for (Serializable t : c) {
            this.delegate.add(t);
        }
        this.sortSet();
    }

    @SafeVarargs
    public final void set(T ... c) {
        this.clear();
        this.add((Serializable[])c);
    }

    @SafeVarargs
    public final void add(T ... c) {
        int i = 0;
        for (T t : c) {
            this.delegate.add(i++, t);
        }
        this.sort();
    }

    public void add(Iterable<T> c) {
        int i = 0;
        for (Serializable t : c) {
            this.delegate.add(i++, t);
        }
        this.sort();
    }

    @SafeVarargs
    public final void remove(T ... c) {
        for (T t : c) {
            this.delegate.remove(t);
        }
    }

    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.unmodifiableIterator(this.delegate.iterator());
    }

    public PriorityCollection<T> getByMIMEType(@Nonnull String mimeType) {
        OWLAPIPreconditions.checkNotNull(mimeType, "MIME-Type cannot be null");
        PriorityCollection<T> pc = new PriorityCollection<T>(this.sorting);
        for (Serializable t : this.delegate) {
            if (!(t instanceof MIMETypeAware)) continue;
            MIMETypeAware mimeTypeAware = (MIMETypeAware)((Object)t);
            if (mimeType.equals(mimeTypeAware.getDefaultMIMEType())) {
                pc.add(new Serializable[]{t});
                continue;
            }
            if (!mimeTypeAware.getMIMETypes().contains(mimeType)) continue;
            pc.add(new Serializable[]{t});
        }
        return pc;
    }

    public String toString() {
        return this.delegate.toString();
    }
}

