/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.multibindings.Multibinder;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.annotations.OwlapiModule;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntologyBuilder;
import org.semanticweb.owlapi.model.OWLOntologyFactory;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import uk.ac.manchester.cs.owl.owlapi.EmptyInMemOWLOntologyFactory;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLOntologyBuilderImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLOntologyManagerImpl;
import uk.ac.manchester.cs.owl.owlapi.ParsableOWLOntologyFactory;

@OwlapiModule
public class OWLAPIImplModule
extends AbstractModule {
    @Nonnull
    @Provides
    protected static OWLDataFactory provideOWLDataFactory() {
        return new OWLDataFactoryImpl(true, false);
    }

    @Nonnull
    @Provides
    protected static OWLOntologyManager provideOWLOntologyManager(@Nonnull OWLDataFactory df) {
        return new OWLOntologyManagerImpl(df);
    }

    @Nonnull
    @Provides
    protected static OWLOntologyBuilder provideOWLOntologyBuilder() {
        return new OWLOntologyBuilderImpl();
    }

    protected void configure() {
        this.multibind(OWLOntologyFactory.class, EmptyInMemOWLOntologyFactory.class, ParsableOWLOntologyFactory.class);
    }

    @SafeVarargs
    private final <T> Multibinder<T> multibind(Class<T> type, Class<? extends T> ... implementations) {
        Multibinder binder = Multibinder.newSetBinder((Binder)this.binder(), type);
        for (Class<? extends T> i : implementations) {
            binder.addBinding().to(i);
        }
        return binder;
    }
}

