/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.OWLCardinalityRestrictionImpl;

public abstract class OWLObjectCardinalityRestrictionImpl
extends OWLCardinalityRestrictionImpl<OWLClassExpression>
implements OWLObjectCardinalityRestriction {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final OWLObjectPropertyExpression property;

    protected OWLObjectCardinalityRestrictionImpl(@Nonnull OWLObjectPropertyExpression property, int cardinality, @Nonnull OWLClassExpression filler) {
        super(cardinality, filler);
        this.property = OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
    }

    @Override
    public void addSignatureEntitiesToSet(Set<OWLEntity> entities) {
        this.addSignatureEntitiesToSetForValue(entities, this.property);
        this.addSignatureEntitiesToSetForValue(entities, this.getFiller());
    }

    @Override
    public void addAnonymousIndividualsToSet(Set<OWLAnonymousIndividual> anons) {
        this.addAnonymousIndividualsToSetForValue(anons, this.property);
        this.addAnonymousIndividualsToSetForValue(anons, this.getFiller());
    }

    @Override
    public OWLObjectPropertyExpression getProperty() {
        return this.property;
    }

    @Override
    public boolean isQualified() {
        return ((OWLClassExpression)this.getFiller()).isAnonymous() || !((OWLClassExpression)this.getFiller()).isOWLThing();
    }

    @Override
    public boolean isObjectRestriction() {
        return true;
    }

    @Override
    public boolean isDataRestriction() {
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OWLObjectCardinalityRestriction)) {
            return false;
        }
        return this.getProperty().equals(((OWLObjectCardinalityRestriction)obj).getProperty());
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLObjectCardinalityRestriction other = (OWLObjectCardinalityRestriction)object;
        int diff = this.getProperty().compareTo(other.getProperty());
        if (diff != 0) {
            return diff;
        }
        diff = this.getCardinality() - other.getCardinality();
        if (diff != 0) {
            return diff;
        }
        return ((OWLClassExpression)this.getFiller()).compareTo(other.getFiller());
    }
}

