/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.google.common.base.Optional;
import com.google.inject.Provider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.semanticweb.owlapi.OWLAPIConfigProvider;
import org.semanticweb.owlapi.io.FileDocumentSource;
import org.semanticweb.owlapi.io.IRIDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSourceBase;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.io.OWLOntologyStorageIOException;
import org.semanticweb.owlapi.io.OWLParserFactory;
import org.semanticweb.owlapi.io.OntologyIRIMappingNotFoundException;
import org.semanticweb.owlapi.io.StreamDocumentSource;
import org.semanticweb.owlapi.io.StreamDocumentTarget;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.DefaultChangeBroadcastStrategy;
import org.semanticweb.owlapi.model.DefaultImpendingChangeBroadcastStrategy;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.ImmutableOWLOntologyChangeException;
import org.semanticweb.owlapi.model.ImpendingOWLOntologyChangeBroadcastStrategy;
import org.semanticweb.owlapi.model.ImpendingOWLOntologyChangeListener;
import org.semanticweb.owlapi.model.MissingImportEvent;
import org.semanticweb.owlapi.model.MissingImportHandlingStrategy;
import org.semanticweb.owlapi.model.MissingImportListener;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLMutableOntology;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyAlreadyExistsException;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeBroadcastStrategy;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyChangeProgressListener;
import org.semanticweb.owlapi.model.OWLOntologyChangeVetoException;
import org.semanticweb.owlapi.model.OWLOntologyChangesVetoedListener;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyDocumentAlreadyExistsException;
import org.semanticweb.owlapi.model.OWLOntologyFactory;
import org.semanticweb.owlapi.model.OWLOntologyFactoryNotFoundException;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyLoaderListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyRenameException;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLStorer;
import org.semanticweb.owlapi.model.OWLStorerFactory;
import org.semanticweb.owlapi.model.OWLStorerNotFoundException;
import org.semanticweb.owlapi.model.PriorityCollectionSorting;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.RemoveImport;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.model.UnknownOWLOntologyException;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.model.parameters.ChangeApplied;
import org.semanticweb.owlapi.model.parameters.OntologyCopy;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.PriorityCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OWLOntologyManagerImpl
implements OWLOntologyManager,
OWLOntologyFactory.OWLOntologyCreationHandler,
Serializable {
    private static final long serialVersionUID = 40000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(OWLOntologyManagerImpl.class);
    @Nonnull
    protected final Map<OWLOntologyID, OWLOntology> ontologiesByID = CollectionFactory.createSyncMap();
    @Nonnull
    protected final Map<OWLOntologyID, IRI> documentIRIsByID = CollectionFactory.createSyncMap();
    @Nonnull
    protected final Map<OWLOntologyID, OWLOntologyLoaderConfiguration> ontologyConfigurationsByOntologyID = new HashMap<OWLOntologyID, OWLOntologyLoaderConfiguration>();
    @Nonnull
    protected final Map<OWLOntologyID, OWLDocumentFormat> ontologyFormatsByOntology = CollectionFactory.createSyncMap();
    @Nonnull
    protected final Map<OWLImportsDeclaration, OWLOntologyID> ontologyIDsByImportsDeclaration = CollectionFactory.createSyncMap();
    private final AtomicBoolean broadcastChanges = new AtomicBoolean(true);
    protected final AtomicInteger loadCount = new AtomicInteger(0);
    protected final AtomicInteger importsLoadCount = new AtomicInteger(0);
    @Nonnull
    protected final Set<IRI> importedIRIs = CollectionFactory.createSyncSet();
    @Nonnull
    protected final OWLDataFactory dataFactory;
    @Nonnull
    protected final Map<OWLOntologyID, Set<OWLOntology>> importsClosureCache = CollectionFactory.createSyncMap();
    @Nonnull
    protected final List<MissingImportListener> missingImportsListeners = CollectionFactory.createSyncList();
    @Nonnull
    protected final List<OWLOntologyLoaderListener> loaderListeners = CollectionFactory.createSyncList();
    @Nonnull
    protected final List<OWLOntologyChangeProgressListener> progressListeners = CollectionFactory.createSyncList();
    @Nonnull
    protected final AtomicLong autoGeneratedURICounter = new AtomicLong();
    @Nonnull
    protected OWLOntologyChangeBroadcastStrategy defaultChangeBroadcastStrategy = new DefaultChangeBroadcastStrategy();
    @Nonnull
    protected ImpendingOWLOntologyChangeBroadcastStrategy defaultImpendingChangeBroadcastStrategy = new DefaultImpendingChangeBroadcastStrategy();
    private transient Map<OWLOntologyChangeListener, OWLOntologyChangeBroadcastStrategy> listenerMap = CollectionFactory.createSyncMap();
    private transient Map<ImpendingOWLOntologyChangeListener, ImpendingOWLOntologyChangeBroadcastStrategy> impendingChangeListenerMap = CollectionFactory.createSyncMap();
    private transient List<OWLOntologyChangesVetoedListener> vetoListeners = new ArrayList<OWLOntologyChangesVetoedListener>();
    @Nonnull
    private Provider<OWLOntologyLoaderConfiguration> configProvider = new OWLAPIConfigProvider();
    @Nonnull
    private Optional<OWLOntologyLoaderConfiguration> config = Optional.absent();
    @Nonnull
    protected final PriorityCollection<OWLOntologyIRIMapper> documentMappers;
    @Nonnull
    protected final PriorityCollection<OWLOntologyFactory> ontologyFactories;
    @Nonnull
    protected final PriorityCollection<OWLParserFactory> parserFactories;
    @Nonnull
    protected final PriorityCollection<OWLStorerFactory> ontologyStorers;

    public OWLOntologyManagerImpl(@Nonnull OWLDataFactory dataFactory, @Nonnull PriorityCollectionSorting sorting) {
        this.dataFactory = OWLAPIPreconditions.checkNotNull(dataFactory, "dataFactory cannot be null");
        this.documentMappers = new PriorityCollection(sorting);
        this.ontologyFactories = new PriorityCollection(sorting);
        this.parserFactories = new PriorityCollection(sorting);
        this.ontologyStorers = new PriorityCollection(sorting);
        this.installDefaultURIMappers();
        this.installDefaultOntologyFactories();
    }

    public OWLOntologyManagerImpl(@Nonnull OWLDataFactory dataFactory) {
        this(dataFactory, PriorityCollectionSorting.ON_SET_INJECTION_ONLY);
    }

    @Override
    public void setOntologyLoaderConfigurationProvider(Provider<OWLOntologyLoaderConfiguration> provider) {
        this.configProvider = provider;
    }

    @Override
    public void setOntologyLoaderConfiguration(OWLOntologyLoaderConfiguration newConfig) {
        this.config = Optional.fromNullable((Object)newConfig);
    }

    @Override
    @Nonnull
    public OWLOntologyLoaderConfiguration getOntologyLoaderConfiguration() {
        if (this.config.isPresent()) {
            return (OWLOntologyLoaderConfiguration)this.config.get();
        }
        this.config = Optional.of((Object)this.configProvider.get());
        return (OWLOntologyLoaderConfiguration)this.config.get();
    }

    @Override
    public OWLDataFactory getOWLDataFactory() {
        return this.dataFactory;
    }

    @Override
    public Set<OWLOntology> getOntologies() {
        return new HashSet<OWLOntology>(this.ontologiesByID.values());
    }

    @Override
    public Set<OWLOntology> getOntologies(OWLAxiom axiom) {
        HashSet<OWLOntology> result = new HashSet<OWLOntology>(this.ontologiesByID.size());
        for (OWLOntology ont : this.getOntologies()) {
            if (!ont.containsAxiom(axiom)) continue;
            result.add(ont);
        }
        return result;
    }

    @Override
    public boolean contains(OWLOntology ontology) {
        return this.ontologiesByID.containsValue(ontology);
    }

    @Override
    public boolean contains(IRI ontologyIRI) {
        OWLAPIPreconditions.checkNotNull(ontologyIRI, "Ontology IRI cannot be null");
        for (OWLOntologyID nextOntologyID : this.ontologiesByID.keySet()) {
            if (!ontologyIRI.equals(nextOntologyID.getOntologyIRI().orNull())) continue;
            return true;
        }
        for (OWLOntologyID ont : this.ontologiesByID.keySet()) {
            if (!ontologyIRI.equals(ont.getVersionIRI().orNull())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(OWLOntologyID id) {
        if (this.ontologiesByID.containsKey(id)) {
            return true;
        }
        for (OWLOntologyID nextOntologyID : this.ontologiesByID.keySet()) {
            if (id.isAnonymous() || !id.getOntologyIRI().equals(nextOntologyID.getOntologyIRI())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsVersion(IRI ontologyVersionIRI) {
        for (OWLOntologyID ont : this.ontologiesByID.keySet()) {
            if (!ontologyVersionIRI.equals(ont.getVersionIRI().orNull())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<OWLOntologyID> getOntologyIDsByVersion(IRI ontologyVersionIRI) {
        TreeSet<OWLOntologyID> result = new TreeSet<OWLOntologyID>();
        for (OWLOntologyID ont : this.ontologiesByID.keySet()) {
            if (!ontologyVersionIRI.equals(ont.getVersionIRI().orNull())) continue;
            result.add(ont);
        }
        return result;
    }

    @Override
    public OWLOntology getOntology(IRI ontologyIRI) {
        OWLOntologyID ontologyID = new OWLOntologyID(this.of(ontologyIRI), this.of(null));
        OWLOntology result = this.ontologiesByID.get(ontologyID);
        if (result == null) {
            for (OWLOntologyID nextOntologyID : this.ontologiesByID.keySet()) {
                if (!ontologyIRI.equals(nextOntologyID.getVersionIRI().orNull()) && !ontologyIRI.equals(nextOntologyID.getOntologyIRI().orNull()) && !ontologyIRI.equals(nextOntologyID.getDefaultDocumentIRI().orNull())) continue;
                result = this.ontologiesByID.get(nextOntologyID);
            }
        }
        return result;
    }

    private static boolean matchingIDs(OWLOntologyID first, OWLOntologyID second) {
        if (first.isAnonymous() || second.isAnonymous()) {
            return first.equals(second);
        }
        return first.getOntologyIRI().equals(second.getOntologyIRI());
    }

    @Override
    public OWLOntology getOntology(OWLOntologyID ontologyID) {
        OWLOntology result = this.ontologiesByID.get(ontologyID);
        if (result == null && !ontologyID.isAnonymous()) {
            for (OWLOntologyID nextOntologyID : this.ontologiesByID.keySet()) {
                if (!OWLOntologyManagerImpl.matchingIDs(ontologyID, nextOntologyID)) continue;
                result = this.ontologiesByID.get(nextOntologyID);
            }
        }
        if (result == null) {
            IRI documentIRI = this.getDocumentIRIFromMappers(ontologyID);
            if (documentIRI == null) {
                documentIRI = !ontologyID.isAnonymous() ? (IRI)ontologyID.getDefaultDocumentIRI().orNull() : IRI.generateDocumentIRI();
                Collection<IRI> existingDocumentIRIs = this.documentIRIsByID.values();
                while (existingDocumentIRIs.contains(documentIRI)) {
                    documentIRI = IRI.generateDocumentIRI();
                }
            }
            if (this.documentIRIsByID.values().contains(documentIRI)) {
                throw new OWLRuntimeException(new OWLOntologyDocumentAlreadyExistsException(documentIRI));
            }
        }
        return result;
    }

    @Override
    public Set<OWLOntology> getVersions(IRI ontologyIRI) {
        HashSet<OWLOntology> result = new HashSet<OWLOntology>();
        for (OWLOntology ont : this.getOntologies()) {
            OWLOntologyID ontId = ont.getOntologyID();
            Optional<IRI> ontIRI = ontId.getOntologyIRI();
            if (!ontIRI.isPresent() || !((IRI)ontIRI.get()).equals(ontologyIRI)) continue;
            result.add(ont);
        }
        return result;
    }

    @Override
    @Nullable
    public OWLOntology getImportedOntology(OWLImportsDeclaration declaration) {
        OWLOntologyID ontologyID = this.ontologyIDsByImportsDeclaration.get(declaration);
        if (ontologyID == null) {
            return this.getOntology(declaration.getIRI());
        }
        return this.getOntology(ontologyID);
    }

    @Override
    public Set<OWLOntology> getDirectImports(OWLOntology ontology) {
        if (!this.contains(ontology)) {
            throw new UnknownOWLOntologyException(ontology.getOntologyID());
        }
        HashSet<OWLOntology> imports = new HashSet<OWLOntology>();
        for (OWLImportsDeclaration axiom : ontology.getImportsDeclarations()) {
            assert (axiom != null);
            OWLOntology importedOntology = this.getImportedOntology(axiom);
            if (importedOntology == null) continue;
            imports.add(importedOntology);
        }
        return imports;
    }

    @Override
    public Set<OWLOntology> getImports(OWLOntology ontology) {
        if (!this.contains(ontology)) {
            throw new UnknownOWLOntologyException(ontology.getOntologyID());
        }
        HashSet<OWLOntology> result = new HashSet<OWLOntology>();
        this.getImports(ontology, result);
        return result;
    }

    private void getImports(@Nonnull OWLOntology ont, @Nonnull Set<OWLOntology> result) {
        for (OWLOntology directImport : this.getDirectImports(ont)) {
            assert (directImport != null);
            if (!result.add(directImport)) continue;
            this.getImports(directImport, result);
        }
    }

    @Override
    public Set<OWLOntology> getImportsClosure(OWLOntology ontology) {
        Set<OWLOntology> ontologies = this.importsClosureCache.get(ontology.getOntologyID());
        if (ontologies == null) {
            ontologies = new LinkedHashSet<OWLOntology>();
            this.getImportsClosure(ontology, ontologies);
            this.importsClosureCache.put(ontology.getOntologyID(), ontologies);
        }
        return CollectionFactory.getCopyOnRequestSetFromMutableCollection(ontologies);
    }

    private void getImportsClosure(@Nonnull OWLOntology ontology, @Nonnull Set<OWLOntology> ontologies) {
        ontologies.add(ontology);
        for (OWLOntology ont : this.getDirectImports(ontology)) {
            assert (ont != null);
            if (ontologies.contains(ont)) continue;
            this.getImportsClosure(ont, ontologies);
        }
    }

    @Override
    public List<OWLOntology> getSortedImportsClosure(OWLOntology ontology) {
        return new ArrayList<OWLOntology>(ontology.getImportsClosure());
    }

    private boolean isChangeApplicable(OWLOntologyChange change) {
        OWLOntologyLoaderConfiguration ontologyConfig = this.ontologyConfigurationsByOntologyID.get(change.getOntology().getOntologyID());
        return ontologyConfig == null || ontologyConfig.isLoadAnnotationAxioms() || !change.isAddAxiom() || !(change.getAxiom() instanceof OWLAnnotationAxiom);
    }

    private List<OWLOntologyChange> enactChangeApplication(OWLOntologyChange change) {
        if (!this.isChangeApplicable(change)) {
            return Collections.emptyList();
        }
        OWLOntology ont = change.getOntology();
        if (!(ont instanceof OWLMutableOntology)) {
            throw new ImmutableOWLOntologyChangeException(change.getChangeData(), ont.toString());
        }
        this.checkForOntologyIDChange(change);
        ChangeApplied appliedChange = ((OWLMutableOntology)ont).applyChange(change);
        this.checkForImportsChange(change);
        if (appliedChange == ChangeApplied.UNSUCCESSFULLY) {
            return Collections.emptyList();
        }
        return Collections.singletonList(change);
    }

    @Override
    public List<OWLOntologyChange> applyChanges(List<? extends OWLOntologyChange> changes) {
        try {
            this.broadcastImpendingChanges(changes);
        }
        catch (OWLOntologyChangeVetoException e) {
            this.broadcastOntologyChangesVetoed(changes, e);
            return CollectionFactory.emptyList();
        }
        ArrayList<OWLOntologyChange> appliedChanges = new ArrayList<OWLOntologyChange>(changes.size() + 2);
        this.fireBeginChanges(changes.size());
        for (OWLOntologyChange oWLOntologyChange : changes) {
            assert (oWLOntologyChange != null);
            appliedChanges.addAll(this.enactChangeApplication(oWLOntologyChange));
            this.fireChangeApplied(oWLOntologyChange);
        }
        this.fireEndChanges();
        this.broadcastChanges(appliedChanges);
        return appliedChanges;
    }

    @Override
    public ChangeApplied addAxiom(@Nonnull OWLOntology ont, @Nonnull OWLAxiom axiom) {
        List<OWLOntologyChange> addAxioms = this.addAxioms(ont, CollectionFactory.createSet(axiom));
        if (addAxioms.isEmpty()) {
            return ChangeApplied.UNSUCCESSFULLY;
        }
        return ChangeApplied.SUCCESSFULLY;
    }

    @Override
    public List<OWLOntologyChange> addAxioms(@Nonnull OWLOntology ont, @Nonnull Set<? extends OWLAxiom> axioms) {
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>(axioms.size() + 2);
        for (OWLAxiom oWLAxiom : axioms) {
            assert (oWLAxiom != null);
            changes.add(new AddAxiom(ont, oWLAxiom));
        }
        return this.applyChanges(changes);
    }

    @Override
    public List<OWLOntologyChange> removeAxiom(@Nonnull OWLOntology ont, @Nonnull OWLAxiom axiom) {
        return this.removeAxioms(ont, CollectionFactory.createSet(axiom));
    }

    @Override
    public List<OWLOntologyChange> removeAxioms(@Nonnull OWLOntology ont, @Nonnull Set<? extends OWLAxiom> axioms) {
        ArrayList<RemoveAxiom> changes = new ArrayList<RemoveAxiom>(axioms.size() + 2);
        for (OWLAxiom oWLAxiom : axioms) {
            assert (oWLAxiom != null);
            changes.add(new RemoveAxiom(ont, oWLAxiom));
        }
        return this.applyChanges(changes);
    }

    @Override
    public ChangeApplied applyChange(@Nonnull OWLOntologyChange change) {
        List<OWLOntologyChange> applyChanges = this.applyChanges(CollectionFactory.list(change));
        if (applyChanges.isEmpty()) {
            return ChangeApplied.UNSUCCESSFULLY;
        }
        return ChangeApplied.SUCCESSFULLY;
    }

    private void checkForImportsChange(OWLOntologyChange change) {
        if (change.isImportChange()) {
            this.resetImportsClosureCache();
            if (change instanceof AddImport) {
                OWLImportsDeclaration addImportDeclaration = ((AddImport)change).getImportDeclaration();
                boolean found = false;
                IRI iri = addImportDeclaration.getIRI();
                for (OWLOntologyID oWLOntologyID : this.ontologiesByID.keySet()) {
                    if (!iri.equals(oWLOntologyID.getDefaultDocumentIRI().orNull()) && !iri.equals(oWLOntologyID.getOntologyIRI().orNull()) && !iri.equals(oWLOntologyID.getVersionIRI().orNull())) continue;
                    found = true;
                    this.ontologyIDsByImportsDeclaration.put(addImportDeclaration, oWLOntologyID);
                }
                if (!found) {
                    for (Map.Entry entry : this.documentIRIsByID.entrySet()) {
                        if (!((IRI)entry.getValue()).equals(iri)) continue;
                        this.ontologyIDsByImportsDeclaration.put(addImportDeclaration, (OWLOntologyID)entry.getKey());
                    }
                }
            } else {
                OWLImportsDeclaration importDeclaration = ((RemoveImport)change).getImportDeclaration();
                this.ontologyIDsByImportsDeclaration.remove(importDeclaration);
                this.importedIRIs.remove(importDeclaration.getIRI());
            }
        }
    }

    private void checkForOntologyIDChange(OWLOntologyChange change) {
        if (change instanceof SetOntologyID) {
            SetOntologyID setID = (SetOntologyID)change;
            OWLOntology existingOntology = this.ontologiesByID.get(((SetOntologyID)change).getNewOntologyID());
            if (existingOntology != null && !change.getOntology().equals(existingOntology) && !change.getOntology().getAxioms().equals(existingOntology.getAxioms())) {
                LOGGER.error("OWLOntologyManagerImpl.checkForOntologyIDChange() existing:{}", (Object)existingOntology);
                LOGGER.error("OWLOntologyManagerImpl.checkForOntologyIDChange() new:{}", (Object)change.getOntology());
                throw new OWLOntologyRenameException(change.getChangeData(), ((SetOntologyID)change).getNewOntologyID());
            }
            this.renameOntology(setID.getOriginalOntologyID(), setID.getNewOntologyID());
            this.resetImportsClosureCache();
        }
    }

    @Override
    public void ontologyCreated(OWLOntology ontology) {
        this.addOntology(ontology);
    }

    @Override
    public void setOntologyFormat(OWLOntology ontology, OWLDocumentFormat ontologyFormat) {
        OWLOntologyID ontologyID = ontology.getOntologyID();
        this.ontologyFormatsByOntology.put(ontologyID, ontologyFormat);
    }

    @Override
    @Nonnull
    public OWLDocumentFormat getOntologyFormat(@Nonnull OWLOntology ontology) {
        OWLOntologyID ontologyID = ontology.getOntologyID();
        return this.ontologyFormatsByOntology.get(ontologyID);
    }

    @Override
    public OWLOntology createOntology() throws OWLOntologyCreationException {
        return this.createOntology(new OWLOntologyID());
    }

    @Override
    public OWLOntology createOntology(@Nonnull IRI ontologyIRI) throws OWLOntologyCreationException {
        return this.createOntology(new OWLOntologyID(this.of(ontologyIRI), this.absent()));
    }

    @Override
    public OWLOntology createOntology(@Nonnull OWLOntologyID ontologyID) throws OWLOntologyCreationException {
        OWLOntology ontology = this.ontologiesByID.get(ontologyID);
        if (ontology != null) {
            throw new OWLOntologyAlreadyExistsException(ontologyID);
        }
        IRI documentIRI = this.getDocumentIRIFromMappers(ontologyID);
        if (documentIRI == null) {
            documentIRI = !ontologyID.isAnonymous() ? (IRI)ontologyID.getDefaultDocumentIRI().orNull() : IRI.generateDocumentIRI();
            Collection<IRI> existingDocumentIRIs = this.documentIRIsByID.values();
            while (existingDocumentIRIs.contains(documentIRI)) {
                documentIRI = IRI.generateDocumentIRI();
            }
        }
        assert (documentIRI != null);
        if (this.documentIRIsByID.values().contains(documentIRI)) {
            throw new OWLOntologyDocumentAlreadyExistsException(documentIRI);
        }
        for (OWLOntologyFactory factory : this.ontologyFactories) {
            if (!factory.canCreateFromDocumentIRI(documentIRI)) continue;
            this.documentIRIsByID.put(ontologyID, documentIRI);
            return factory.createOWLOntology(this, ontologyID, documentIRI, this);
        }
        throw new OWLOntologyFactoryNotFoundException(documentIRI);
    }

    @Override
    public OWLOntology createOntology(IRI ontologyIRI, Set<OWLOntology> ontologies) throws OWLOntologyCreationException {
        return this.createOntology(ontologyIRI, ontologies, false);
    }

    @Override
    public OWLOntology createOntology(IRI ontologyIRI, Set<OWLOntology> ontologies, boolean copyLogicalAxiomsOnly) throws OWLOntologyCreationException {
        if (this.contains(ontologyIRI)) {
            throw new OWLOntologyAlreadyExistsException(new OWLOntologyID(this.of(ontologyIRI), this.absent()));
        }
        OWLOntology ont = this.createOntology(ontologyIRI);
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        for (OWLOntology ontology : ontologies) {
            if (copyLogicalAxiomsOnly) {
                axioms.addAll(ontology.getLogicalAxioms());
                continue;
            }
            axioms.addAll(ontology.getAxioms());
        }
        this.addAxioms(ont, axioms);
        return ont;
    }

    @Override
    public OWLOntology createOntology(Set<OWLAxiom> axioms, IRI ontologyIRI) throws OWLOntologyCreationException {
        if (this.contains(ontologyIRI)) {
            throw new OWLOntologyAlreadyExistsException(new OWLOntologyID(this.of(ontologyIRI), this.absent()));
        }
        OWLOntology ont = this.createOntology(ontologyIRI);
        this.addAxioms(ont, axioms);
        return ont;
    }

    @Override
    public OWLOntology createOntology(Set<OWLAxiom> axioms) throws OWLOntologyCreationException {
        return this.createOntology(axioms, OWLOntologyManagerImpl.getNextAutoGeneratedIRI());
    }

    @Nonnull
    protected static IRI getNextAutoGeneratedIRI() {
        return OWLOntologyDocumentSourceBase.getNextDocumentIRI("owlapi:ontology#ont");
    }

    @Override
    public OWLOntology copyOntology(OWLOntology toCopy, OntologyCopy settings) throws OWLOntologyCreationException {
        OWLAPIPreconditions.checkNotNull(toCopy);
        OWLAPIPreconditions.checkNotNull(settings);
        OWLOntology toReturn = null;
        if (settings == OntologyCopy.MOVE) {
            toReturn = toCopy;
            this.ontologiesByID.put(toReturn.getOntologyID(), toReturn);
        } else if (settings == OntologyCopy.SHALLOW || settings == OntologyCopy.DEEP) {
            toReturn = this.createOntology(toCopy.getOntologyID());
            for (AxiomType<?> type : AxiomType.AXIOM_TYPES) {
                assert (type != null);
                this.addAxioms(toReturn, toCopy.getAxioms(type));
            }
            for (OWLAnnotation a : toCopy.getAnnotations()) {
                assert (a != null);
                this.applyChange(new AddOntologyAnnotation(toReturn, a));
            }
        }
        assert (toReturn != null);
        OWLOntologyManager m = toCopy.getOWLOntologyManager();
        if (settings == OntologyCopy.MOVE || settings == OntologyCopy.DEEP) {
            this.setOntologyDocumentIRI(toReturn, m.getOntologyDocumentIRI(toCopy));
            OWLDocumentFormat f = m.getOntologyFormat(toCopy);
            if (f != null) {
                this.setOntologyFormat(toReturn, f);
            }
        }
        if (settings == OntologyCopy.MOVE) {
            m.removeOntology(toCopy);
            toReturn.setOWLOntologyManager(this);
        }
        return toReturn;
    }

    @Override
    public OWLOntology loadOntology(IRI ontologyIRI) throws OWLOntologyCreationException {
        return this.loadOntology(ontologyIRI, false, this.getOntologyLoaderConfiguration());
    }

    @Nonnull
    protected OWLOntology loadOntology(@Nonnull IRI ontologyIRI, boolean allowExists, @Nonnull OWLOntologyLoaderConfiguration configuration) throws OWLOntologyCreationException {
        OWLOntology ontByID = null;
        for (OWLOntologyID nextOntologyID : this.ontologiesByID.keySet()) {
            if (!ontologyIRI.equals(nextOntologyID.getOntologyIRI().orNull())) continue;
            ontByID = this.ontologiesByID.get(nextOntologyID);
        }
        if (ontByID == null) {
            for (OWLOntologyID nextOntologyID : this.ontologiesByID.keySet()) {
                if (!ontologyIRI.equals(nextOntologyID.getVersionIRI().orNull())) continue;
                ontByID = this.ontologiesByID.get(nextOntologyID);
            }
        }
        if (ontByID != null) {
            return ontByID;
        }
        OWLOntologyID id = new OWLOntologyID(this.of(ontologyIRI), this.absent());
        IRI documentIRI = this.getDocumentIRIFromMappers(id);
        if (documentIRI != null) {
            if (this.documentIRIsByID.values().contains(documentIRI) && !allowExists) {
                throw new OWLOntologyDocumentAlreadyExistsException(documentIRI);
            }
            OWLOntology ontByDocumentIRI = this.getOntologyByDocumentIRI(documentIRI);
            if (ontByDocumentIRI != null) {
                return ontByDocumentIRI;
            }
        } else {
            throw new OntologyIRIMappingNotFoundException(ontologyIRI);
        }
        return this.loadOntology(ontologyIRI, new IRIDocumentSource(documentIRI, null, null), configuration);
    }

    private OWLOntology getOntologyByDocumentIRI(IRI documentIRI) {
        for (OWLOntologyID ontID : this.documentIRIsByID.keySet()) {
            assert (ontID != null);
            IRI docIRI = this.documentIRIsByID.get(ontID);
            if (docIRI == null || !docIRI.equals(documentIRI)) continue;
            return this.getOntology(ontID);
        }
        return null;
    }

    @Override
    public OWLOntology loadOntologyFromOntologyDocument(IRI documentIRI) throws OWLOntologyCreationException {
        return this.loadOntology(null, new IRIDocumentSource(documentIRI, null, null), this.getOntologyLoaderConfiguration());
    }

    @Override
    public OWLOntology loadOntologyFromOntologyDocument(OWLOntologyDocumentSource documentSource) throws OWLOntologyCreationException {
        return this.loadOntology(null, documentSource, this.getOntologyLoaderConfiguration());
    }

    @Override
    public OWLOntology loadOntologyFromOntologyDocument(OWLOntologyDocumentSource documentSource, OWLOntologyLoaderConfiguration conf) throws OWLOntologyCreationException {
        return this.loadOntology(null, documentSource, conf);
    }

    @Override
    public OWLOntology loadOntologyFromOntologyDocument(File file) throws OWLOntologyCreationException {
        return this.loadOntologyFromOntologyDocument(new FileDocumentSource(file));
    }

    @Override
    public OWLOntology loadOntologyFromOntologyDocument(InputStream inputStream) throws OWLOntologyCreationException {
        return this.loadOntologyFromOntologyDocument(new StreamDocumentSource(inputStream));
    }

    /*
     * Exception decompiling
     */
    @Nonnull
    protected OWLOntology loadOntology(@Nullable IRI ontologyIRI, @Nonnull OWLOntologyDocumentSource documentSource, @Nonnull OWLOntologyLoaderConfiguration configuration) throws OWLOntologyCreationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 9[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void removeOntology(OWLOntology ontology) {
        this.removeOntology(ontology.getOntologyID());
        ontology.setOWLOntologyManager(null);
    }

    @Override
    public void removeOntology(OWLOntologyID ontologyID) {
        this.ontologiesByID.remove(ontologyID);
        this.ontologyFormatsByOntology.remove(ontologyID);
        this.documentIRIsByID.remove(ontologyID);
        this.resetImportsClosureCache();
    }

    private void addOntology(OWLOntology ont) {
        this.ontologiesByID.put(ont.getOntologyID(), ont);
        this.resetImportsClosureCache();
    }

    @Override
    public IRI getOntologyDocumentIRI(OWLOntology ontology) {
        if (!this.contains(ontology)) {
            throw new UnknownOWLOntologyException(ontology.getOntologyID());
        }
        return OWLAPIPreconditions.verifyNotNull(this.documentIRIsByID.get(ontology.getOntologyID()));
    }

    @Override
    public void setOntologyDocumentIRI(OWLOntology ontology, IRI documentIRI) {
        if (!this.ontologiesByID.containsKey(ontology.getOntologyID())) {
            throw new UnknownOWLOntologyException(ontology.getOntologyID());
        }
        this.documentIRIsByID.put(ontology.getOntologyID(), documentIRI);
    }

    private void renameOntology(OWLOntologyID oldID, OWLOntologyID newID) {
        IRI documentIRI;
        OWLOntology ont = this.ontologiesByID.get(oldID);
        if (ont == null) {
            return;
        }
        this.ontologiesByID.remove(oldID);
        this.ontologiesByID.put(newID, ont);
        if (this.ontologyFormatsByOntology.containsKey(oldID)) {
            this.ontologyFormatsByOntology.put(newID, this.ontologyFormatsByOntology.remove(oldID));
        }
        if ((documentIRI = this.documentIRIsByID.remove(oldID)) != null) {
            this.documentIRIsByID.put(newID, documentIRI);
        }
        this.resetImportsClosureCache();
    }

    protected void resetImportsClosureCache() {
        this.importsClosureCache.clear();
    }

    @Override
    public void saveOntology(OWLOntology ontology) throws OWLOntologyStorageException {
        OWLDocumentFormat format = this.getOntologyFormat(ontology);
        this.saveOntology(ontology, format);
    }

    @Override
    public void saveOntology(@Nonnull OWLOntology ontology, OWLDocumentFormat ontologyFormat) throws OWLOntologyStorageException {
        this.saveOntology(ontology, ontologyFormat, this.getOntologyDocumentIRI(ontology));
    }

    @Override
    public void saveOntology(OWLOntology ontology, IRI documentIRI) throws OWLOntologyStorageException {
        OWLDocumentFormat format = this.getOntologyFormat(ontology);
        this.saveOntology(ontology, format, documentIRI);
    }

    @Override
    public void saveOntology(OWLOntology ontology, OWLDocumentFormat ontologyFormat, IRI documentIRI) throws OWLOntologyStorageException {
        try {
            for (OWLStorerFactory storer : this.ontologyStorers) {
                if (!storer.getFormatFactory().getKey().equals(ontologyFormat.getKey())) continue;
                ((OWLStorer)storer.get()).storeOntology(ontology, documentIRI, ontologyFormat);
                return;
            }
            throw new OWLStorerNotFoundException(ontologyFormat);
        }
        catch (IOException e) {
            throw new OWLOntologyStorageIOException(e);
        }
    }

    @Override
    public void saveOntology(OWLOntology ontology, OutputStream outputStream) throws OWLOntologyStorageException {
        this.saveOntology(ontology, new StreamDocumentTarget(outputStream));
    }

    @Override
    public void saveOntology(OWLOntology ontology, OWLDocumentFormat ontologyFormat, OutputStream outputStream) throws OWLOntologyStorageException {
        this.saveOntology(ontology, ontologyFormat, new StreamDocumentTarget(outputStream));
    }

    @Override
    public void saveOntology(OWLOntology ontology, OWLOntologyDocumentTarget documentTarget) throws OWLOntologyStorageException {
        this.saveOntology(ontology, this.getOntologyFormat(ontology), documentTarget);
    }

    @Override
    public void saveOntology(OWLOntology ontology, OWLDocumentFormat ontologyFormat, OWLOntologyDocumentTarget documentTarget) throws OWLOntologyStorageException {
        String formatKey = ontologyFormat.getKey();
        try {
            for (OWLStorerFactory storer : this.ontologyStorers) {
                String key = storer.getFormatFactory().getKey();
                if (!key.equals(formatKey)) continue;
                ((OWLStorer)storer.get()).storeOntology(ontology, documentTarget, ontologyFormat);
                return;
            }
            throw new OWLStorerNotFoundException(ontologyFormat);
        }
        catch (IOException e) {
            throw new OWLOntologyStorageIOException(e);
        }
    }

    @Override
    @Inject
    public void setOntologyStorers(Set<OWLStorerFactory> storers) {
        this.ontologyStorers.set(storers);
    }

    @Override
    public PriorityCollection<OWLStorerFactory> getOntologyStorers() {
        return this.ontologyStorers;
    }

    @Override
    @Inject
    public void setIRIMappers(Set<OWLOntologyIRIMapper> mappers) {
        this.documentMappers.set(mappers);
    }

    @Override
    public PriorityCollection<OWLOntologyIRIMapper> getIRIMappers() {
        return this.documentMappers;
    }

    @Override
    public void addIRIMapper(OWLOntologyIRIMapper mapper) {
        this.documentMappers.add(new OWLOntologyIRIMapper[]{mapper});
    }

    @Override
    public void removeIRIMapper(OWLOntologyIRIMapper mapper) {
        this.documentMappers.remove(new OWLOntologyIRIMapper[]{mapper});
    }

    @Override
    public void clearIRIMappers() {
        this.documentMappers.clear();
    }

    @Override
    public void addOntologyStorer(OWLStorerFactory storer) {
        this.ontologyStorers.add(new OWLStorerFactory[]{storer});
    }

    @Override
    public void removeOntologyStorer(OWLStorerFactory storer) {
        this.ontologyStorers.remove(new OWLStorerFactory[]{storer});
    }

    @Override
    public void clearOntologyStorers() {
        this.ontologyStorers.clear();
    }

    @Override
    @Inject
    public void setOntologyFactories(Set<OWLOntologyFactory> factories) {
        this.ontologyFactories.set(factories);
    }

    @Override
    @Inject
    public void setOntologyParsers(Set<OWLParserFactory> parsers) {
        this.parserFactories.set(parsers);
    }

    @Override
    public PriorityCollection<OWLParserFactory> getOntologyParsers() {
        return this.parserFactories;
    }

    @Override
    public PriorityCollection<OWLOntologyFactory> getOntologyFactories() {
        return this.ontologyFactories;
    }

    @Nullable
    private IRI getDocumentIRIFromMappers(OWLOntologyID ontologyID) {
        Optional<IRI> defIRI = ontologyID.getDefaultDocumentIRI();
        if (!defIRI.isPresent()) {
            return null;
        }
        IRI iri = (IRI)defIRI.get();
        assert (iri != null);
        for (OWLOntologyIRIMapper mapper : this.documentMappers) {
            IRI documentIRI = mapper.getDocumentIRI(iri);
            if (documentIRI == null) continue;
            return documentIRI;
        }
        return iri;
    }

    protected final void installDefaultURIMappers() {
    }

    protected final void installDefaultOntologyFactories() {
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.listenerMap = new ConcurrentHashMap<OWLOntologyChangeListener, OWLOntologyChangeBroadcastStrategy>();
        this.impendingChangeListenerMap = new ConcurrentHashMap<ImpendingOWLOntologyChangeListener, ImpendingOWLOntologyChangeBroadcastStrategy>();
        this.vetoListeners = new ArrayList<OWLOntologyChangesVetoedListener>();
    }

    @Override
    public void addOntologyChangeListener(OWLOntologyChangeListener listener) {
        this.listenerMap.put(listener, this.defaultChangeBroadcastStrategy);
    }

    protected void broadcastChanges(@Nonnull List<? extends OWLOntologyChange> changes) {
        if (!this.broadcastChanges.get()) {
            return;
        }
        for (OWLOntologyChangeListener listener : new ArrayList<OWLOntologyChangeListener>(this.listenerMap.keySet())) {
            assert (listener != null);
            OWLOntologyChangeBroadcastStrategy strategy = this.listenerMap.get(listener);
            if (strategy == null) continue;
            try {
                strategy.broadcastChanges(listener, changes);
            }
            catch (Exception e) {
                LOGGER.warn("BADLY BEHAVING LISTENER: {} has been removed", (Object)e.getMessage(), (Object)e);
                this.listenerMap.remove(listener);
            }
        }
    }

    protected void broadcastImpendingChanges(@Nonnull List<? extends OWLOntologyChange> changes) {
        if (!this.broadcastChanges.get()) {
            return;
        }
        for (ImpendingOWLOntologyChangeListener listener : new ArrayList<ImpendingOWLOntologyChangeListener>(this.impendingChangeListenerMap.keySet())) {
            assert (listener != null);
            ImpendingOWLOntologyChangeBroadcastStrategy strategy = this.impendingChangeListenerMap.get(listener);
            if (strategy == null) continue;
            strategy.broadcastChanges(listener, changes);
        }
    }

    @Override
    public void setDefaultChangeBroadcastStrategy(OWLOntologyChangeBroadcastStrategy strategy) {
        this.defaultChangeBroadcastStrategy = strategy;
    }

    @Override
    public void addOntologyChangeListener(OWLOntologyChangeListener listener, OWLOntologyChangeBroadcastStrategy strategy) {
        this.listenerMap.put(listener, strategy);
    }

    @Override
    public void addImpendingOntologyChangeListener(ImpendingOWLOntologyChangeListener listener) {
        this.impendingChangeListenerMap.put(listener, this.defaultImpendingChangeBroadcastStrategy);
    }

    @Override
    public void removeImpendingOntologyChangeListener(ImpendingOWLOntologyChangeListener listener) {
        this.impendingChangeListenerMap.remove(listener);
    }

    @Override
    public void removeOntologyChangeListener(OWLOntologyChangeListener listener) {
        this.listenerMap.remove(listener);
    }

    @Override
    public void addOntologyChangesVetoedListener(OWLOntologyChangesVetoedListener listener) {
        this.vetoListeners.add(listener);
    }

    @Override
    public void removeOntologyChangesVetoedListener(OWLOntologyChangesVetoedListener listener) {
        this.vetoListeners.remove(listener);
    }

    private void broadcastOntologyChangesVetoed(@Nonnull List<? extends OWLOntologyChange> changes, @Nonnull OWLOntologyChangeVetoException veto) {
        for (OWLOntologyChangesVetoedListener listener : new ArrayList<OWLOntologyChangesVetoedListener>(this.vetoListeners)) {
            listener.ontologyChangesVetoed(changes, veto);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OWLOntology loadImports(OWLImportsDeclaration declaration, @Nonnull OWLOntologyLoaderConfiguration configuration) throws OWLOntologyCreationException {
        this.importsLoadCount.incrementAndGet();
        OWLOntology ont = null;
        try {
            ont = this.loadOntology(declaration.getIRI(), true, configuration);
        }
        catch (OWLOntologyCreationException e) {
            if (configuration.getMissingImportHandlingStrategy() == MissingImportHandlingStrategy.THROW_EXCEPTION) {
                throw e;
            }
            MissingImportEvent evt = new MissingImportEvent(declaration.getIRI(), e);
            this.fireMissingImportEvent(evt);
        }
        finally {
            this.importsLoadCount.decrementAndGet();
        }
        return ont;
    }

    @Override
    public void makeLoadImportRequest(OWLImportsDeclaration declaration) {
        this.makeLoadImportRequest(declaration, this.getOntologyLoaderConfiguration());
    }

    @Override
    public void makeLoadImportRequest(OWLImportsDeclaration declaration, OWLOntologyLoaderConfiguration configuration) {
        IRI iri = declaration.getIRI();
        if (!configuration.isIgnoredImport(iri) && !this.importedIRIs.contains(iri)) {
            this.importedIRIs.add(iri);
            try {
                OWLOntology ont = this.loadImports(declaration, configuration);
                if (ont != null) {
                    this.ontologyIDsByImportsDeclaration.put(declaration, ont.getOntologyID());
                }
            }
            catch (OWLOntologyCreationException e) {
                throw new UnloadableImportException(e, declaration);
            }
        }
    }

    @Override
    public void addMissingImportListener(MissingImportListener listener) {
        this.missingImportsListeners.add(listener);
    }

    @Override
    public void removeMissingImportListener(@Nonnull MissingImportListener listener) {
        this.missingImportsListeners.remove(listener);
    }

    protected void fireMissingImportEvent(@Nonnull MissingImportEvent evt) {
        for (MissingImportListener listener : new ArrayList<MissingImportListener>(this.missingImportsListeners)) {
            listener.importMissing(evt);
        }
    }

    @Override
    public void addOntologyLoaderListener(OWLOntologyLoaderListener listener) {
        this.loaderListeners.add(listener);
    }

    @Override
    public void removeOntologyLoaderListener(OWLOntologyLoaderListener listener) {
        this.loaderListeners.remove(listener);
    }

    protected void fireStartedLoadingEvent(OWLOntologyID ontologyID, IRI documentIRI, boolean imported) {
        for (OWLOntologyLoaderListener listener : new ArrayList<OWLOntologyLoaderListener>(this.loaderListeners)) {
            listener.startedLoadingOntology(new OWLOntologyLoaderListener.LoadingStartedEvent(ontologyID, documentIRI, imported));
        }
    }

    protected void fireFinishedLoadingEvent(OWLOntologyID ontologyID, IRI documentIRI, boolean imported, Exception ex) {
        for (OWLOntologyLoaderListener listener : new ArrayList<OWLOntologyLoaderListener>(this.loaderListeners)) {
            listener.finishedLoadingOntology(new OWLOntologyLoaderListener.LoadingFinishedEvent(ontologyID, documentIRI, imported, ex));
        }
    }

    @Override
    public void addOntologyChangeProgessListener(OWLOntologyChangeProgressListener listener) {
        this.progressListeners.add(listener);
    }

    @Override
    public void removeOntologyChangeProgessListener(OWLOntologyChangeProgressListener listener) {
        this.progressListeners.remove(listener);
    }

    protected void fireBeginChanges(int size) {
        if (!this.broadcastChanges.get()) {
            return;
        }
        for (OWLOntologyChangeProgressListener listener : this.progressListeners) {
            try {
                listener.begin(size);
            }
            catch (Exception e) {
                LOGGER.warn("BADLY BEHAVING LISTENER: {} has been removed", (Object)e.getMessage(), (Object)e);
                this.progressListeners.remove(listener);
            }
        }
    }

    protected void fireEndChanges() {
        if (!this.broadcastChanges.get()) {
            return;
        }
        for (OWLOntologyChangeProgressListener listener : this.progressListeners) {
            try {
                listener.end();
            }
            catch (Exception e) {
                LOGGER.warn("BADLY BEHAVING LISTENER: {} has been removed", (Object)e.getMessage(), (Object)e);
                this.progressListeners.remove(listener);
            }
        }
    }

    protected void fireChangeApplied(@Nonnull OWLOntologyChange change) {
        if (!this.broadcastChanges.get()) {
            return;
        }
        if (this.progressListeners.isEmpty()) {
            return;
        }
        for (OWLOntologyChangeProgressListener listener : this.progressListeners) {
            try {
                listener.appliedChange(change);
            }
            catch (Exception e) {
                LOGGER.warn("BADLY BEHAVING LISTENER: {} has been removed", (Object)e.getMessage(), (Object)e);
                this.progressListeners.remove(listener);
            }
        }
    }

    @Nonnull
    protected <T> Optional<T> of(T t) {
        return Optional.fromNullable(t);
    }

    @Nonnull
    protected Optional<IRI> absent() {
        return Optional.absent();
    }
}

