/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.PSystem;
import net.sourceforge.plantuml.UmlSource;
import net.sourceforge.plantuml.version.License;
import net.sourceforge.plantuml.version.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPSystem
implements PSystem {
    private UmlSource source;

    private String getVersion() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PlantUML version ");
        stringBuilder.append(Version.versionString());
        stringBuilder.append("(" + new Date(Version.compileTime()) + ")\n");
        if (License.isCloseSource()) {
            stringBuilder.append("(Close source distribution)\n");
        }
        Properties properties = System.getProperties();
        stringBuilder.append(properties.getProperty("java.runtime.name"));
        stringBuilder.append('\n');
        stringBuilder.append(properties.getProperty("java.vm.name"));
        stringBuilder.append('\n');
        stringBuilder.append(properties.getProperty("java.runtime.version"));
        stringBuilder.append('\n');
        stringBuilder.append(properties.getProperty("os.name"));
        return stringBuilder.toString();
    }

    @Override
    public final String getMetadata() {
        if (this.source == null) {
            return this.getVersion();
        }
        return this.source.getPlainString() + "\n" + this.getVersion();
    }

    @Override
    public final UmlSource getSource() {
        return this.source;
    }

    public final void setSource(UmlSource umlSource) {
        this.source = umlSource;
    }

    @Override
    public int getNbImages() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<File> exportDiagrams(File file, FileFormatOption fileFormatOption) throws IOException, InterruptedException {
        if (file.exists() && file.isDirectory()) {
            throw new IllegalArgumentException("File is a directory " + file);
        }
        OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            this.exportDiagram(outputStream, null, 0, fileFormatOption);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        return Arrays.asList(file);
    }

    public List<? extends CharSequence> getTitle() {
        if (this.source == null) {
            return Collections.emptyList();
        }
        return this.source.getTitle();
    }

    @Override
    public String getWarningOrError() {
        return null;
    }

    public void makeDiagramReady() {
    }
}

