/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import net.sourceforge.plantuml.AlignParam;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.dot.DotSplines;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizLayoutStrategy;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.svek.PackageStyle;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.Sprite;
import net.sourceforge.plantuml.ugraphic.UFont;

public class SkinParamBackcolored
implements ISkinParam {
    private final ISkinParam skinParam;
    private final HtmlColor backColorElement;
    private final HtmlColor backColorGeneral;
    private final boolean forceClickage;

    public SkinParamBackcolored(ISkinParam iSkinParam, HtmlColor htmlColor) {
        this(iSkinParam, htmlColor, null, false);
    }

    public SkinParamBackcolored(ISkinParam iSkinParam, HtmlColor htmlColor, boolean bl) {
        this(iSkinParam, htmlColor, null, bl);
    }

    public SkinParamBackcolored(ISkinParam iSkinParam, HtmlColor htmlColor, HtmlColor htmlColor2) {
        this(iSkinParam, htmlColor, htmlColor2, false);
    }

    public SkinParamBackcolored(ISkinParam iSkinParam, HtmlColor htmlColor, HtmlColor htmlColor2, boolean bl) {
        this.skinParam = iSkinParam;
        this.forceClickage = bl;
        this.backColorElement = htmlColor;
        this.backColorGeneral = htmlColor2;
    }

    public HtmlColor getBackgroundColor() {
        if (this.backColorGeneral != null) {
            return this.backColorGeneral;
        }
        return this.skinParam.getBackgroundColor();
    }

    public int getCircledCharacterRadius() {
        return this.skinParam.getCircledCharacterRadius();
    }

    public UFont getFont(FontParam fontParam, String string) {
        return this.skinParam.getFont(fontParam, string);
    }

    public HtmlColor getFontHtmlColor(FontParam fontParam, String string) {
        return this.skinParam.getFontHtmlColor(fontParam, string);
    }

    public HtmlColor getHtmlColor(ColorParam colorParam, String string, boolean bl) {
        if (colorParam.isBackground() && this.backColorElement != null) {
            return this.backColorElement;
        }
        if (this.forceClickage) {
            bl = true;
        }
        return this.skinParam.getHtmlColor(colorParam, string, bl);
    }

    public String getValue(String string) {
        return this.skinParam.getValue(string);
    }

    public boolean isClassCollapse() {
        return this.skinParam.isClassCollapse();
    }

    public int classAttributeIconSize() {
        return this.skinParam.classAttributeIconSize();
    }

    public int getDpi() {
        return this.skinParam.getDpi();
    }

    public boolean useOctagonForActivity() {
        return this.skinParam.useOctagonForActivity();
    }

    public DotSplines getDotSplines() {
        return this.skinParam.getDotSplines();
    }

    public GraphvizLayoutStrategy getStrategy() {
        return this.skinParam.getStrategy();
    }

    public HorizontalAlignement getHorizontalAlignement(AlignParam alignParam) {
        return this.skinParam.getHorizontalAlignement(alignParam);
    }

    public ColorMapper getColorMapper() {
        return this.skinParam.getColorMapper();
    }

    public boolean shadowing() {
        return this.skinParam.shadowing();
    }

    public PackageStyle getPackageStyle() {
        return this.skinParam.getPackageStyle();
    }

    public Sprite getSprite(String string) {
        return this.skinParam.getSprite(string);
    }

    public boolean useUml2ForComponent() {
        return this.skinParam.useUml2ForComponent();
    }

    public boolean stereotypePositionTop() {
        return this.skinParam.stereotypePositionTop();
    }

    public boolean useSwimlanes() {
        return this.skinParam.useSwimlanes();
    }

    public double getNodesep() {
        return this.skinParam.getNodesep();
    }

    public double getRanksep() {
        return this.skinParam.getRanksep();
    }

    public double getRoundCorner() {
        return this.skinParam.getRoundCorner();
    }
}

