/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.CMapData;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.PSystem;
import net.sourceforge.plantuml.Pragma;
import net.sourceforge.plantuml.Scale;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.UmlDiagramInfo;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.flashcode.FlashCodeFactory;
import net.sourceforge.plantuml.flashcode.FlashCodeUtils;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.mjpeg.MJPEGGenerator;
import net.sourceforge.plantuml.pdf.PdfConverter;
import net.sourceforge.plantuml.ugraphic.Sprite;
import net.sourceforge.plantuml.ugraphic.UFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UmlDiagram
extends AbstractPSystem
implements PSystem {
    private boolean rotation;
    private boolean hideUnlinkedData;
    private int minwidth = Integer.MAX_VALUE;
    private List<? extends CharSequence> title;
    private List<String> header;
    private List<String> footer;
    private HorizontalAlignement headerAlignement = HorizontalAlignement.RIGHT;
    private HorizontalAlignement footerAlignement = HorizontalAlignement.CENTER;
    private final Pragma pragma = new Pragma();
    private Scale scale;
    private final SkinParam skinParam = new SkinParam(this.getUmlDiagramType());
    private UmlDiagramInfo lastInfo;

    public final void setTitle(List<? extends CharSequence> list) {
        this.title = list;
    }

    @Override
    public final List<? extends CharSequence> getTitle() {
        return this.title;
    }

    public final int getMinwidth() {
        return this.minwidth;
    }

    public final void setMinwidth(int n) {
        this.minwidth = n;
    }

    public final boolean isRotation() {
        return this.rotation;
    }

    public final void setRotation(boolean bl) {
        this.rotation = bl;
    }

    public final ISkinParam getSkinParam() {
        return this.skinParam;
    }

    public void setParam(String string, String string2) {
        this.skinParam.setParam(string.toLowerCase(), string2);
    }

    public final List<String> getHeader() {
        return this.header;
    }

    public final void setHeader(List<String> list) {
        this.header = list;
    }

    public final List<String> getFooter() {
        return this.footer;
    }

    public final void setFooter(List<String> list) {
        this.footer = list;
    }

    public final HorizontalAlignement getHeaderAlignement() {
        return this.headerAlignement;
    }

    public final void setHeaderAlignement(HorizontalAlignement horizontalAlignement) {
        this.headerAlignement = horizontalAlignement;
    }

    public final HorizontalAlignement getFooterAlignement() {
        return this.footerAlignement;
    }

    public final void setFooterAlignement(HorizontalAlignement horizontalAlignement) {
        this.footerAlignement = horizontalAlignement;
    }

    public abstract UmlDiagramType getUmlDiagramType();

    public Pragma getPragma() {
        return this.pragma;
    }

    public final void setScale(Scale scale) {
        this.scale = scale;
    }

    public final Scale getScale() {
        return this.scale;
    }

    public final double getDpiFactor(FileFormatOption fileFormatOption) {
        if (this.getSkinParam().getDpi() == 96) {
            return 1.0;
        }
        return (double)this.getSkinParam().getDpi() / 96.0;
    }

    public final int getDpi(FileFormatOption fileFormatOption) {
        return this.getSkinParam().getDpi();
    }

    public final boolean isHideUnlinkedData() {
        return this.hideUnlinkedData;
    }

    public final void setHideUnlinkedData(boolean bl) {
        this.hideUnlinkedData = bl;
    }

    @Override
    public final void exportDiagram(OutputStream outputStream, CMapData cMapData, int n, FileFormatOption fileFormatOption) throws IOException {
        List<BufferedImage> list = null;
        try {
            String string;
            if ("split".equalsIgnoreCase(this.getSkinParam().getValue("flashcode")) && fileFormatOption.getFileFormat() == FileFormat.PNG) {
                string = this.getSource().getPlainString();
                list = this.getFlashCodeUtils().exportSplitCompress(string);
            } else if ("compress".equalsIgnoreCase(this.getSkinParam().getValue("flashcode")) && fileFormatOption.getFileFormat() == FileFormat.PNG) {
                string = this.getSource().getPlainString();
                list = this.getFlashCodeUtils().exportFlashcodeCompress(string);
            } else if (this.getSkinParam().getValue("flashcode") != null && fileFormatOption.getFileFormat() == FileFormat.PNG) {
                string = this.getSource().getPlainString();
                list = this.getFlashCodeUtils().exportFlashcodeSimple(string);
            }
        }
        catch (IOException iOException) {
            Log.error("Cannot generate flashcode");
            iOException.printStackTrace();
            list = null;
        }
        if (fileFormatOption.getFileFormat() == FileFormat.PDF) {
            this.exportDiagramInternalPdf(outputStream, cMapData, n, list);
            return;
        }
        if (fileFormatOption.getFileFormat() == FileFormat.MJPEG) {
            throw new UnsupportedOperationException();
        }
        try {
            this.lastInfo = this.exportDiagramInternal(outputStream, cMapData, n, fileFormatOption, list);
        }
        catch (Exception exception) {
            this.exportDiagramError(outputStream, exception, fileFormatOption);
        }
    }

    private void exportDiagramError(OutputStream outputStream, Exception exception, FileFormatOption fileFormatOption) throws IOException {
        UFont uFont = new UFont("SansSerif", 0, 12);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("An error has occured : " + exception);
        arrayList.add(" ");
        arrayList.add("PlantUML cannot parse result from dot/GraphViz.");
        arrayList.add(" ");
        arrayList.add("This may be caused by :");
        arrayList.add(" - a bug in PlantUML");
        arrayList.add(" - a problem in GraphViz");
        arrayList.add(" ");
        arrayList.add("You should send this diagram and this image to <b>plantuml@gmail.com</b> to solve this issue.");
        arrayList.add("You can try to turn arround this issue by simplifing your diagram.");
        arrayList.add(" ");
        arrayList.add(exception.toString());
        for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
            arrayList.add("  " + stackTraceElement.toString());
        }
        GraphicStrings graphicStrings = new GraphicStrings(arrayList, uFont, HtmlColorUtils.BLACK, HtmlColorUtils.WHITE, false);
        graphicStrings.writeImage(outputStream, fileFormatOption);
    }

    private FlashCodeUtils getFlashCodeUtils() {
        return FlashCodeFactory.getFlashCodeUtils();
    }

    private void exportDiagramInternalMjpeg(OutputStream outputStream) throws IOException {
        File file = new File("c:/test.avi");
        MJPEGGenerator mJPEGGenerator = new MJPEGGenerator(file, 640, 480, 30.0, 150);
        for (int i = 0; i < 150; ++i) {
            AffineTransform affineTransform = new AffineTransform();
            double d = (double)(149 - i) * 1.0 / 150.0;
            affineTransform.setToShear(d, d);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.exportDiagram(byteArrayOutputStream, null, 0, new FileFormatOption(FileFormat.PNG, affineTransform));
            byteArrayOutputStream.close();
            BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            mJPEGGenerator.addImage(bufferedImage);
        }
        mJPEGGenerator.finishAVI();
    }

    private void exportDiagramInternalPdf(OutputStream outputStream, CMapData cMapData, int n, List<BufferedImage> list) throws IOException {
        File file = FileUtils.createTempFile("pdf", ".svf");
        File file2 = FileUtils.createTempFile("pdf", ".pdf");
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        this.exportDiagram(bufferedOutputStream, cMapData, n, new FileFormatOption(FileFormat.SVG));
        ((OutputStream)bufferedOutputStream).close();
        PdfConverter.convert(file, file2);
        FileUtils.copyToStream(file2, outputStream);
    }

    protected abstract UmlDiagramInfo exportDiagramInternal(OutputStream var1, CMapData var2, int var3, FileFormatOption var4, List<BufferedImage> var5) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void exportCmap(File file, CMapData cMapData) throws FileNotFoundException {
        String string = UmlDiagram.changeName(file.getAbsolutePath());
        File file2 = new File(string);
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(file2);
            printWriter.print(cMapData.asString(file2.getName().substring(0, file2.getName().length() - 6)));
            printWriter.close();
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    static String changeName(String string) {
        return string.replaceAll("(?i)\\.\\w{3}$", ".cmapx");
    }

    @Override
    public String getWarningOrError() {
        if (this.lastInfo == null) {
            return null;
        }
        double d = this.lastInfo.getWidth();
        if (d == 0.0) {
            return null;
        }
        String string = this.getSkinParam().getValue("widthwarning");
        if (string == null) {
            return null;
        }
        if (!string.matches("\\d+")) {
            return null;
        }
        int n = Integer.parseInt(string);
        if (d > (double)n) {
            return "The image is " + (int)d + " pixel width. (Warning limit is " + n + ")";
        }
        return null;
    }

    public void addSprite(String string, Sprite sprite) {
        this.skinParam.addSprite(string, sprite);
    }
}

