/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram.command;

import java.util.List;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.activitydiagram.ActivityDiagram;
import net.sourceforge.plantuml.activitydiagram.command.CommandLinkActivity;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLinkLongActivity
extends CommandMultilines2<ActivityDiagram> {
    public CommandLinkLongActivity(ActivityDiagram activityDiagram) {
        super(activityDiagram, CommandLinkLongActivity.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE);
    }

    @Override
    public String getPatternEnd() {
        return "(?i)^\\s*([^\"]*)\"(?:\\s+as\\s+([\\p{L}0-9][\\p{L}0-9_.]*))?\\s*(\\<\\<.*\\>\\>)?\\s*(?:in\\s+(\"[^\"]+\"|\\S+))?\\s*(#\\w+)?$";
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexOr("FIRST", true, new RegexLeaf("STAR", "(\\(\\*(top)?\\))"), new RegexLeaf("CODE", "([\\p{L}0-9][\\p{L}0-9_.]*)"), new RegexLeaf("BAR", "(?:==+)\\s*([\\p{L}0-9_.]+)\\s*(?:==+)"), new RegexLeaf("QUOTED", "\"([^\"]+)\"(?:\\s+as\\s+([\\p{L}0-9_.]+))?")), new RegexLeaf("\\s*"), new RegexLeaf("STEREOTYPE", "(\\<\\<.*\\>\\>)?"), new RegexLeaf("\\s*"), new RegexLeaf("BACKCOLOR", "(#\\w+)?"), new RegexLeaf("\\s*"), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("ARROW", "([-=.]+(?:(left|right|up|down|le?|ri?|up?|do?)(?=[-=.]))?[-=.]*\\>)"), new RegexLeaf("\\s*"), new RegexLeaf("BRACKET", "(?:\\[([^\\]*]+[^\\]]*)\\])?"), new RegexLeaf("\\s*"), new RegexLeaf("DESC", "\"([^\"]*?)"), new RegexLeaf("\\s*"), new RegexLeaf("$"));
    }

    @Override
    public CommandExecutionResult executeNow(List<String> list) {
        Object object;
        UrlBuilder urlBuilder;
        StringUtils.trim(list, false);
        RegexResult regexResult = this.getStartingPattern().matcher(list.get(0).trim());
        IEntity iEntity = CommandLinkActivity.getEntity((ActivityDiagram)this.getSystem(), regexResult, true);
        if (regexResult.get("STEREOTYPE", 0) != null) {
            iEntity.setStereotype(new Stereotype(regexResult.get("STEREOTYPE", 0)));
        }
        if (regexResult.get("BACKCOLOR", 0) != null) {
            iEntity.setSpecificBackcolor(HtmlColorUtils.getColorIfValid(regexResult.get("BACKCOLOR", 0)));
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = regexResult.get("DESC", 0);
        Url url = null;
        if (StringUtils.isNotEmpty(string) && (url = (urlBuilder = new UrlBuilder(((ActivityDiagram)this.getSystem()).getSkinParam().getValue("topurl"), true)).getUrl(string)) == null) {
            stringBuilder.append(string);
            stringBuilder.append("\\n");
        }
        for (int i = 1; i < list.size() - 1; ++i) {
            if (i == 1 && url == null && (url = ((UrlBuilder)(object = new UrlBuilder(((ActivityDiagram)this.getSystem()).getSkinParam().getValue("topurl"), true))).getUrl(list.get(i))) != null) continue;
            stringBuilder.append(list.get(i));
            if (i >= list.size() - 2) continue;
            stringBuilder.append("\\n");
        }
        List<String> list2 = StringUtils.getSplit(Pattern.compile(this.getPatternEnd()), list.get(list.size() - 1));
        if (StringUtils.isNotEmpty(list2.get(0))) {
            if (stringBuilder.length() > 0 && !stringBuilder.toString().endsWith("\\n")) {
                stringBuilder.append("\\n");
            }
            stringBuilder.append(list2.get(0));
        }
        object = stringBuilder.toString();
        Code code = Code.of((String)(list2.get(1) == null ? object : list2.get(1)));
        String string2 = null;
        if (list2.get(3) != null) {
            string2 = list2.get(3);
            string2 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string2);
        }
        if (string2 != null) {
            ((ActivityDiagram)this.getSystem()).getOrCreateGroup(Code.of(string2), StringUtils.getWithNewlines(string2), null, GroupType.PACKAGE, null);
        }
        ILeaf iLeaf = ((ActivityDiagram)this.getSystem()).createLeaf(code, StringUtils.getWithNewlines((String)object), LeafType.ACTIVITY);
        if (string2 != null) {
            ((ActivityDiagram)this.getSystem()).endGroup();
        }
        if (url != null) {
            iLeaf.addUrl(url);
        }
        if (list2.get(2) != null) {
            iLeaf.setStereotype(new Stereotype(list2.get(2)));
        }
        if (list2.get(4) != null) {
            iLeaf.setSpecificBackcolor(HtmlColorUtils.getColorIfValid(list2.get(4)));
        }
        if (iEntity == null || iLeaf == null) {
            return CommandExecutionResult.error("No such entity");
        }
        String string3 = StringUtils.manageArrowForCuca(regexResult.get("ARROW", 0));
        int n = string3.length() - 1;
        String string4 = regexResult.get("BRACKET", 0);
        LinkType linkType = new LinkType(LinkDecor.ARROW, LinkDecor.NONE);
        if (regexResult.get("ARROW", 0).contains(".")) {
            linkType = linkType.getDotted();
        }
        Link link = new Link(iEntity, iLeaf, linkType, string4, n);
        Direction direction = StringUtils.getArrowDirection(regexResult.get("ARROW", 0));
        if (direction == Direction.LEFT || direction == Direction.UP) {
            link = link.getInv();
        }
        if (regexResult.get("URL", 0) != null) {
            UrlBuilder urlBuilder2 = new UrlBuilder(((ActivityDiagram)this.getSystem()).getSkinParam().getValue("topurl"), true);
            Url url2 = urlBuilder2.getUrl(regexResult.get("URL", 0));
            link.setUrl(url2);
        }
        ((ActivityDiagram)this.getSystem()).addLink(link);
        return CommandExecutionResult.ok();
    }
}

