/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram2;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.LeafType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionalContext2 {
    private final Collection<IEntity> pendings = new LinkedHashSet<IEntity>();
    private final IEntity branch;
    private final Direction direction;
    private final ConditionalContext2 parent;
    private final String when;
    private boolean hasElse = false;

    public ConditionalContext2(ConditionalContext2 conditionalContext2, IEntity iEntity, Direction direction, String string) {
        if (iEntity.getEntityType() != LeafType.BRANCH) {
            throw new IllegalArgumentException();
        }
        this.branch = iEntity;
        this.direction = direction;
        this.parent = conditionalContext2;
        this.when = string;
        this.pendings.add(iEntity);
    }

    public Direction getDirection() {
        return this.direction;
    }

    public final ConditionalContext2 getParent() {
        return this.parent;
    }

    public final Collection<IEntity> getPendings() {
        return Collections.unmodifiableCollection(this.pendings);
    }

    public final IEntity getBranch() {
        return this.branch;
    }

    public void clearPendingsButFirst() {
        this.pendings.clear();
        this.pendings.add(this.branch);
    }

    public void executeElse(Collection<IEntity> collection) {
        if (this.hasElse) {
            throw new IllegalStateException();
        }
        this.hasElse = true;
        if (this.pendings.size() == 0) {
            throw new IllegalStateException();
        }
        Iterator<IEntity> iterator = this.pendings.iterator();
        IEntity iEntity = iterator.next();
        if (iEntity.getEntityType() != LeafType.BRANCH) {
            throw new IllegalStateException();
        }
        iterator.remove();
        this.pendings.addAll(collection);
    }

    public boolean isHasElse() {
        return this.hasElse;
    }

    public final String getWhen() {
        return this.when;
    }
}

