/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram;

import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.objectdiagram.AbstractClassOrObjectDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDiagram
extends AbstractClassOrObjectDiagram {
    private String namespaceSeparator = ".";

    @Override
    public ILeaf getOrCreateLeaf1(Code code, LeafType leafType) {
        if (leafType == null) {
            code = code.eventuallyRemoveStartingAndEndingDoubleQuote();
            if (this.getNamespaceSeparator() == null) {
                return this.getOrCreateLeaf1Default(code, LeafType.CLASS);
            }
            if (super.leafExist(code = code.getFullyQualifiedCode(this.getCurrentGroup(), this.getNamespaceSeparator()))) {
                return this.getOrCreateLeaf1Default(code, LeafType.CLASS);
            }
            return this.createEntityWithNamespace(code, StringUtils.getWithNewlines(code.getShortName(this.getLeafs(), this.getNamespaceSeparator())), LeafType.CLASS);
        }
        if (this.getNamespaceSeparator() == null) {
            return this.getOrCreateLeaf1Default(code, LeafType.CLASS);
        }
        if (super.leafExist(code = code.getFullyQualifiedCode(this.getCurrentGroup(), this.getNamespaceSeparator()))) {
            return this.getOrCreateLeaf1Default(code, leafType);
        }
        return this.createEntityWithNamespace(code, StringUtils.getWithNewlines(code.getShortName(this.getLeafs(), this.getNamespaceSeparator())), leafType);
    }

    @Override
    public ILeaf createLeaf(Code code, List<? extends CharSequence> list, LeafType leafType) {
        if (leafType != LeafType.ABSTRACT_CLASS && leafType != LeafType.CLASS && leafType != LeafType.INTERFACE && leafType != LeafType.ENUM && leafType != LeafType.LOLLIPOP) {
            return super.createLeaf(code, list, leafType);
        }
        if (this.getNamespaceSeparator() == null) {
            return super.createLeaf(code, list, leafType);
        }
        if (super.leafExist(code = code.getFullyQualifiedCode(this.getCurrentGroup(), this.getNamespaceSeparator()))) {
            throw new IllegalArgumentException("Already known: " + code);
        }
        return this.createEntityWithNamespace(code, list, leafType);
    }

    private ILeaf createEntityWithNamespace(Code code, List<? extends CharSequence> list, LeafType leafType) {
        IGroup iGroup = this.getCurrentGroup();
        String string = code.getNamespace(this.getLeafs(), this.getNamespaceSeparator());
        if (string != null && (EntityUtils.groupRoot(iGroup) || !iGroup.getCode().getCode().equals(string))) {
            iGroup = this.getOrCreateGroupInternal(Code.of(string), StringUtils.getWithNewlines(string), string, GroupType.PACKAGE, this.getRootGroup());
        }
        return this.createLeafInternal(code, list == null ? StringUtils.getWithNewlines(code.getShortName(this.getLeafs(), this.getNamespaceSeparator())) : list, leafType, iGroup);
    }

    @Override
    public final boolean leafExist(Code code) {
        if (this.getNamespaceSeparator() == null) {
            return super.leafExist(code);
        }
        return super.leafExist(code.getFullyQualifiedCode(this.getCurrentGroup(), this.getNamespaceSeparator()));
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.CLASS;
    }

    private String getNamespaceSeparator() {
        return this.namespaceSeparator;
    }

    public void setNamespaceSeparator(String string) {
        this.namespaceSeparator = string;
    }
}

